package com.bokesoft.yigo.meta.report;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaReportSubList定义由表单或者其它分类定义的报表模板的集合，这些集合中的模板具有管理上的相似性，通常为相同数据源的不同的报表形式。
 * @author 王元和
 *
 */
public class MetaReportSubList extends GenericKeyCollectionWithKey<MetaReportProfile> implements IElementMerge<MetaReportSubList> {
	/** 报表子列表标识 */
	private String key = "";
	public MetaReportSubList() {
		super();
	}
	
	/**
	 * 设置报表子列表标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return this.key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public MetaReportSubList toMerge(MetaReportSubList obj) {
		if (obj != null) {
			Iterator<MetaReportProfile> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaReportProfile metaReportProfile = (MetaReportProfile) iterator.next();
				if (containsKey(metaReportProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_REPORE_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatReportDefined),
									metaReportProfile.getProject().getKey(), metaReportProfile.getKey()));
				}
				add(metaReportProfile);
			}
		}
		return this;
	}

}
