package com.bokesoft.yigo.meta.path;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;

public class MetaRelationProxyAction extends BaseDomAction<MetaRelationProxy> {

	@Override
	public void load(Document document, Element element, MetaRelationProxy meta, int runType) {
		// TODO Auto-generated method stub
		meta.setName(DomHelper.readAttr(element, MetaRelationConstants.RELATION_NAME, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.COMMON_IMPL, ""));
		meta.setDatacache(DomHelper.readAttr(element, MetaRelationConstants.RELATION_DATACACHE, false));
		
	}

	@Override
	public void save(Document document, Element element, MetaRelationProxy meta, int runType) {
		// TODO Auto-generated method stub
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_NAME, meta.getName(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_IMPL, meta.getImpl(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_DATACACHE, meta.isCache(), false);
	}

}
