package com.bokesoft.yigo.meta.path;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.common.def.PathTargetType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 数据关系检查规则
 * 
 * @author 刘翔翔
 *
 */
public class MetaRelationPath extends GenericKeyCollection<MetaRelationNode> {

	public static final String TAG_NAME = "Path";

	/** 检查规则的KEY */
	private String key = "";
	/** 目标类型 */
	private int type = PathTargetType.DATAOBJECT;
	/** 目标表单标识 */
	private String formkey = "";
	/** 目标对象标识 */
	private String targetkey = "";
	/** 检查规则的中文描述 */
	private String caption = "";
	/** 节点的ID分配区间 */
	private Integer IDseed = -1;
	/** 横坐标 */
	private Integer x = -1;
	/** 纵坐标 */
	private Integer y = -1;

	public void setKey(String key) {
		this.key = key;
	}

	public String getKey() {
		return key;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getCaption() {
		return caption;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaRelationNode.TAG_NAME.equals(tagName)) {
			MetaRelationNode relationNode = new MetaRelationNode();
			relationNode.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(relationNode);
			resultMetaObject = relationNode;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelationPath();
	}

	public Integer getX() {
		return x;
	}

	public void setX(Integer x) {
		this.x = x;
	}

	public Integer getY() {
		return y;
	}

	public void setY(Integer y) {
		this.y = y;
	}

	public Integer getIDseed() {
		return IDseed;
	}

	public void setIDseed(Integer iDseed) {
		IDseed = iDseed;
	}

	public void setFormkey(String formkey) {
		this.formkey = formkey;
	}

	public String getFormkey() {
		return formkey;
	}

	public void setTargetkey(String targetkey) {
		this.targetkey = targetkey;
	}

	public String getTargetkey() {
		return targetkey;
	}

	public void setType(int type) {
		this.type = type;
	}

	public int getType() {
		return type;
	}

	/**
	 * 通过节点标识寻找node
	 * 
	 * @param key 标识
	 * @return node 节点
	 */
	public MetaRelationNode getNode(String key) {
		Iterator<MetaRelationNode> iterator = this.iterator();
		MetaRelationNode node = new MetaRelationNode();
		while (iterator.hasNext()) {
			node = iterator.next();
			if (node.getDataobjectkey().equals(key)) {
				return node;
			}
		}
		return null;
	}
	
	/**
	 * 通过节点id寻找node
	 * @param id 节点数字标识
	 * @return 关系节点
	 */
	public MetaRelationNode getNode(Integer id){
		Iterator<MetaRelationNode> iterator = this.iterator();
		MetaRelationNode node = new MetaRelationNode();
		while (iterator.hasNext()) {
			node = iterator.next();
			if (node.getId().equals(id)) {
				return node;
			}
		}
		return null;
	}

}
