package com.bokesoft.yigo.meta.parameter;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.*;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

import java.util.LinkedList;

/**
 * zhangk
 */
public class MetaParameter extends GenericKeyCollection<MetaParameterID> implements IPropertyMerger<MetaParameter> {

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {

    }

    public static final String TAG_NAME = "Parameter";

    @Override
    public String getTagName() {
        return TAG_NAME;
    }


    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
                                                    Object node, String tagName, Object flag, int runType)
            throws MetaException {
        AbstractMetaObject resultMetaObject = null;
        if ( MetaParameterID.TAG_NAME.equals(tagName) ) {
            MetaParameterID parameterID = new MetaParameterID();
            parameterID.preProcessMetaObject(env, doc, node, flag, runType);
            if (this.containsKey(parameterID.getKey()) ) {

                throw new RuntimeException("参数ID重复定义" + parameterID.getKey()+" "+ parameterID.getDescription());

                //此注释等下次合并到内网时重写
//                throw new MetaException(MetaException.REPEAT_PARA_GROUP_DEFINED, SimpleStringFormat.format(
//                        StringTable.getString(null, "", StringTable.RepeatParaGroupDefined),  parameterID.getKey()));
            }
            this.add(parameterID);
            resultMetaObject = parameterID;
        }
        return resultMetaObject;
    }
    public boolean needPreLoad() {
        return true;
    }
    @Override
    public AbstractMetaObject newInstance() {
        return new MetaParameter();
    }

    @Override
    public void merge(MetaParameter metaParameterIDS) {

    }
}
