package com.bokesoft.yigo.meta.group;

import java.util.LinkedList;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 数据规则
 * 
 * @author 刘翔翔
 *
 */
public class MetaGroup extends AbstractMetaObject {

	public static final String TAG = "Group";

	/** 拆分规则的提供者 */
	private String splitProxyProvider = "";

	/** 独立数据源 */
	private MetaIndepandentDBSourceCollection indepandentDBSourceCollection = null;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(indepandentDBSourceCollection);
	}

	@Override
	public String getTagName() {
		return TAG;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaIndepandentDBSourceCollection.TAG.equals(tagName)) {
			indepandentDBSourceCollection = new MetaIndepandentDBSourceCollection();
			resultMetaObject = indepandentDBSourceCollection;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGroup();
	}

	public String getSplitProxyProvider() {
		return splitProxyProvider;
	}

	public void setSplitProxyProvider(String splitProxyProvider) {
		this.splitProxyProvider = splitProxyProvider;
	}

	public MetaIndepandentDBSourceCollection getIndepandentDBSourceCollection() {
		return indepandentDBSourceCollection;
	}

	public void setIndepandentDBSourceCollection(MetaIndepandentDBSourceCollection indepandentDBSourceCollection) {
		this.indepandentDBSourceCollection = indepandentDBSourceCollection;
	}

}
