package com.bokesoft.yigo.meta.form.component.panel.gridpanel;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaColumnDefCollection extends GenericNoKeyCollection<MetaColumnDef> {
	/** 列间隔 */
	private Integer columnGap = 0;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}
	
	/**
	 * 设置列间隔
	 * @param columnGap 列间隔
	 */
	public void setColumnGap(Integer columnGap) {
		this.columnGap = columnGap;
	}
	
	/**
	 * 取得列间隔
	 * @return 列间隔
	 */
	public Integer getColumnGap() {
		return this.columnGap;
	}

	public static final String TAG_NAME = "ColumnDefCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		MetaColumnDef metaColumnDef = null;
		if (MetaColumnDef.TAG_NAME.equalsIgnoreCase(tagName)) {
			metaColumnDef = new MetaColumnDef();
			this.add(metaColumnDef);
		}
		return metaColumnDef;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaColumnDefCollection newObject = (MetaColumnDefCollection)super.clone();
		newObject.setColumnGap(columnGap);
		
		return newObject;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaColumnDefCollection();
	}

}
