package com.bokesoft.yigo.meta.form.component.panel;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.TabMode;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutTabItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTabLayout;

/**
 * 分页布局面板对象，属于布局类控件
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaTabPanel extends MetaPanel {
	
	/** 配置文件中对应节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_TABPANEL;

	/** Tab页的相对分页栏的位置（上、下、左、右） */
	private Integer tabPosition = DirectionType.TOP;
	
	/** 模式，默认为Fixed-固定，可选值还有Scrollable-可滚动*/
	private Integer tabMode = TabMode.Fixed;
	
	/** 指示器高度*/
	private DefSize indicatorHeight = null;
	
	/** 指示器颜色*/
	private String indicatorColor = "";
	
	/** 是否显示选项卡*/
	private Boolean showHead = true;
	
	/** Tab页切换触发事件 */
	private MetaBaseScript itemChanged = null;
	
	/** 是否Tab页头悬停 */
	private Boolean hoverHead = false;
	
	/***
	 * 设置是否Tab页头悬停
	 * @param hoverHead 是否Tab页头悬停
	 */
	public void setHoverHead(Boolean hoverHead) {
		this.hoverHead = hoverHead;
	}
	
	/**
	 * 获取是否Tab页头悬停
	 * @return 是否Tab页头悬停
	 */
	public Boolean isHoverHead() {
		return hoverHead;
	}
	
	/**
	 * 设置Tab页的相对分页栏的位置（上、下、左、右）
	 * 
	 * @param position
	 *            Tab页的相对分页栏的位置（上、下、左、右）
	 */
	public void setTabPosition(Integer position) {
		this.tabPosition = position;
	}

	/**
	 * 获取tab页的相对分页栏的位置（上、下、左、右）
	 * 
	 * @return Tab页的相对分页栏的位置（上、下、左、右）
	 */
	public Integer getTabPosition() {
		return this.tabPosition;
	}
	
	/**
	 * 设置选项卡显示模式
	 * @param tabMode 显示模式，参考{@link TabMode}
	 */
	public void setTabMode(Integer tabMode) {
		this.tabMode = tabMode;
	}
	
	/**
	 * 获取选项卡显示模式
	 * @return 显示模式，参考{@link TabMode}
	 */
	public Integer getTabMode() {
		return tabMode;
	}

	/**
	 * 设置指示器高度
	 * @param indicatorHeight 指示器高度
	 */
	public void setIndicatorHeight(DefSize indicatorHeight) {
		this.indicatorHeight = indicatorHeight;
	}
	
	/**
	 * 获取指示器高度
	 * @return 指示器高度
	 */
	public DefSize getIndicatorHeight() {
		return indicatorHeight;
	}
	
	/**
	 * 设置指示器颜色
	 * @param indicatorColor 指示器颜色
	 */
	public void setIndicatorColor(String indicatorColor) {
		this.indicatorColor = indicatorColor;
	}
	
	/**
	 * 获取指示器颜色
	 * @return 指示器颜色
	 */
	public String getIndicatorColor() {
		return indicatorColor;
	}
	
	/**
	 * 设置是否显示选项卡
	 * @param showHead 是否显示选项卡
	 */
	public void setShowHead(Boolean showHead) {
		this.showHead = showHead;
	}
	
	/**
	 * 是否显示选项卡
	 * @return 是否显示选项卡
	 */
	public Boolean isShowHead() {
		return showHead;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.TABPANEL;
	}

	/**
	 * 获取Tab页切换触发事件
	 * @return 事件
	 */
	public MetaBaseScript getItemChanged() {
		return itemChanged;
	}

	/**
	 * 设置Tab页切换触发事件
	 * @param itemChanged 事件
	 */
	public void setItemChanged(MetaBaseScript itemChanged) {
		this.itemChanged = itemChanged;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		if( itemChanged != null ) {
			list.add(itemChanged);
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		if( tagName.equalsIgnoreCase(MetaConstants.TABPANEL_ITEMCHANGED) ) {
			itemChanged = new MetaBaseScript(MetaConstants.TABPANEL_ITEMCHANGED);
			return itemChanged;
		}
		return super.createChildMetaObject(env, doc, node, tagName, flag, runType);
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTabPanel newObject = (MetaTabPanel)super.clone();
		newObject.setTabPosition(tabPosition);
		newObject.setTabMode(tabMode);
		newObject.setIndicatorHeight(indicatorHeight);
		newObject.setIndicatorColor(indicatorColor);
		newObject.setShowHead(showHead);
		newObject.setItemChanged(itemChanged == null ? null : (MetaBaseScript)itemChanged.clone());
		newObject.setHoverHead(hoverHead);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTabPanel();
	}
	
	/**
	 * 从多栏布局面板中生成多栏布局
	 * @return 多栏布局
	 */
	@Override
	public MetaTabLayout newLayout() {
		MetaTabLayout layout = new MetaTabLayout();
		layout.setKey(key);
		layout.setTabPosition(tabPosition);
		layout.setTabMode(tabMode);
		layout.setIndicatorColor(indicatorColor);
		layout.setIndicatorHeight(indicatorHeight);
		layout.setShowHead(showHead);
		layout.setItemChanged(itemChanged);
		layout.setHoverHead(hoverHead);
		Iterator<MetaComponent> it = this.componentArray.iterator();
		MetaComponent metaComponent = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			MetaLayoutTabItem item = new MetaLayoutTabItem();
			item.setKey(metaComponent.getKey());
			item.setCaption(metaComponent.getCaption());
			layout.add(item);
		}
		return layout;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public void merge(MetaComponent meta) {
		super.merge(meta);
		
		MetaTabPanel metaPanel = (MetaTabPanel)meta;
		
		if( this.tabPosition == -1 ) {
			this.tabPosition = metaPanel.getTabPosition();
		}
		if(tabMode == -1){
			this.tabMode = metaPanel.getTabMode();
		}
		if(indicatorColor == null){
			indicatorColor = metaPanel.getIndicatorColor();
		}
		if(indicatorHeight == null){
			indicatorHeight = metaPanel.getIndicatorHeight();
		}
		if(showHead == null){
			showHead = metaPanel.isShowHead();
		}
		if(hoverHead == null){
			hoverHead = metaPanel.isHoverHead();
		}
		MetaBaseScript itemChange = metaPanel.getItemChanged();
		if( itemChange != null && this.itemChanged == null ) {
			this.itemChanged = (MetaBaseScript) itemChange.clone();
		}
	}
}
