package com.bokesoft.yigo.meta.form.component.html;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

/**
 * HTML元素a对象
 * 
 * @author 陈志盛
 * @since YES1.0
 */
public class MetaHtml_A extends MetaHtmlElement {

	/** 在新窗口中打开被链接文档 */
	public static final int TARGET_BLANK = 0;
	/** 在父框架中打开被链接文档 */
	public static final int TARGET_PARENT = 1;
	/** 在被点击时的同一框架中打开被链接文档（默认） */
	public static final int TARGET_SELF = 2;
	/** 在窗口主体中打开被链接文档 */
	public static final int TARGET_TOP = 3;

	/** 配置文件中对应片段的标签名称 */
	public static final String TAG_NAME = ControlType.STR_HTML_ELEMENT_A;

	/** 链接的目标 URL */
	private String href = "";

	/** 在何处打开目标 URL,仅在 href 属性存在时使用 */
	private Integer target = TARGET_BLANK;

	/**
	 * 设置链接目标的URL
	 * 
	 * @param url
	 *            链接目标的URL
	 */
	public void setHrefURL(String url) {
		this.href = url;
	}

	/**
	 * 获取链接目标的URL
	 * 
	 * @return 链接目标的URL
	 */
	public String getHrefURL() {
		return href;
	}

	/**
	 * 设置在何处打开目标URL
	 * 
	 * @param type
	 *            打开类型
	 */
	public void setTargetType(Integer type) {
		this.target = type;
	}

	/**
	 * 获取目标URL打开类型
	 * 
	 * @return 打开类型
	 */
	public Integer getTargetType() {
		return target;
	}

	/**
	 * 通过目标打开类型字符串获取打开类型
	 * 
	 * @param typeStr
	 *            打开类型字符串
	 * @return 打开类型
	 */
	public int parseType(String typeStr) {
		if (typeStr.equalsIgnoreCase("BLANK")) {
			return TARGET_BLANK;
		} else if (typeStr.equalsIgnoreCase("PARENT")) {
			return TARGET_PARENT;
		} else if (typeStr.equalsIgnoreCase("SELF")) {
			return TARGET_SELF;
		} else if (typeStr.equalsIgnoreCase("TOP")) {
			return TARGET_TOP;
		}
		return -1;
	}

	/**
	 * 获取目标打开类型字符串
	 * @return 类型字符串
	 */
	public String getTargetTypeStr() {
		switch (target) {
		case TARGET_BLANK:
			return "Blank";
		case TARGET_PARENT:
			return "Parent";
		case TARGET_SELF:
			return "Self";
		case TARGET_TOP:
			return "Top";
		}
		return "";
	}

	@Override
	public int getControlType() {
		return ControlType.HTML_ELEMENT_A;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaHtml_A newObject = (MetaHtml_A)super.clone();
		newObject.setHrefURL(href);
		newObject.setTargetType(target);

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaHtml_A();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}
