package com.bokesoft.yigo.meta.form.component.grid;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
/**
 * 行分组元数据对象
 * 绑定在{@link MetaGridCell}上的子对象,详见配置文件
 * 
 * @author 陈瑞
 *
 */
public class MetaRowGroup extends MetaBaseScript{
	/**处理标识，取值为Dict(字典)及其它(先不定)；默认值为空*/
	private String tag = "";
	/**Tag取值为Dict时用于指定分组依据的字典标识*/
	private String itemKey = "";
	/**字典项目的掩码标识，后面再确定意义，目前无用处*/
	private String itemMask = "";
	
	public static final String TAG_NAME = "RowGroup";
	
	public MetaRowGroup() {
		super(TAG_NAME);
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getItemKey() {
		return itemKey;
	}

	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}

	public String getItemMask() {
		return itemMask;
	}

	public void setItemMask(String itemMask) {
		this.itemMask = itemMask;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRowGroup rowGroup = (MetaRowGroup)super.clone();
		rowGroup.setItemKey(itemKey);
		rowGroup.setItemMask(itemMask);
		rowGroup.setTag(tag);
		return rowGroup;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRowGroup();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		// TODO
	}
	
}
