package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaGridRowLayer定义网格行层次结构，内部使用。行的层次结构由行对象和区域组成，结构如下：
 * <pre>
 *+-----------------+--------------------+---------------+
 *| Fix             |                    |               |
 *+-----------------+--------------------+---------------+
 *| Fix             |                    |               |
 *+-----------------+--------------------+---------------+
 *|                 |   Group            |               |
 *| Area            +--------------------+---------------+
 *|                 |           Group    |               |       
 *|				    +--------------------+---------------+
 *|                 |           Detail   |               |
 *|                 +--------------------+---------------+
 *|                 |        Group       |               |
 *|                 +--------------------+---------------+
 *|                 |   Group            |               |
 *+-----------------+--------------------+---------------+
 *| Fix             |                    |               |
 *+-----------------+--------------------+---------------+
 * </pre>
 * <p>
 * 其中Area只能有一个
 * </p>
 * @author 王元和
 *
 */
public class MetaGridRowLayer extends AbstractMetaObject {
	private ArrayList<IMetaGridRowObject> objectArray = null;
	/** 数据区域编号*/
	private int areaIndex = -1;
	
	public MetaGridRowLayer() {
		super();
		objectArray = new ArrayList<IMetaGridRowObject>();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "GridRowLayer";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	public void addObject(IMetaGridRowObject row) {
		objectArray.add(row);
	}
	
	public int getObjectCount() {
		return objectArray.size();
	}
	
	public IMetaGridRowObject getObject(int index) {
		return objectArray.get(index);
	}
	
	public void remove(int index){
		this.objectArray.remove(index);
	}
	
	public void printDebugInfo() {
		Iterator<IMetaGridRowObject> it = objectArray.iterator();
		IMetaGridRowObject row = null;
		while ( it.hasNext() ) {
			row = it.next();
			row.printDebugInfo(0);
		}
	}

	@Override
	public AbstractMetaObject clone() {
		return this.newInstance();
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridRowLayer();
	}
	
	public void getAll(int objectType, ArrayList<IMetaGridRowObject> list) {
		Iterator<IMetaGridRowObject> it = objectArray.iterator();
		IMetaGridRowObject rowObject = null;
		while ( it.hasNext() ) {
			rowObject = it.next();
			if ( rowObject.getObjectType() == objectType ) {
				list.add(rowObject);
			}
			rowObject.getAll(objectType, list);
		}
	}

	/**
	 * 获取根分组
	 * @return 根分组
	 */
	public MetaGridRowGroup getRootGroup() {
		return (MetaGridRowGroup) getRowArea().getObject(0);
	}
	
	/**
	 * 获取数据区域
	 * @return 数据区域
	 */
	public MetaGridRowArea getRowArea() {
		return (MetaGridRowArea) objectArray.get(areaIndex);
	}
	
	/**
	 * 获取数据区域编号
	 * @return 数据区域编号
	 */
	public int getAreaIndex() {
		return areaIndex;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		this.areaIndex = -1;
		for( int i = 0,size = objectArray.size();i < size;i++ ) {
			IMetaGridRowObject rowObject = objectArray.get(i);
			if( rowObject.getObjectType() == IMetaGridRowObject.Area ) {
				this.areaIndex = i;
				break;
			}
		}
	}
}
