package com.bokesoft.yigo.meta.form.component.control.tableview;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.ItemAnimType;
import com.bokesoft.yigo.common.def.TableViewRowType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * 表视图配置对象
 */

public class MetaTableView extends MetaComponent {
	public static final String TAG_NAME = ControlType.STR_TABLEVIEW;

	/** 行集合 */
	private MetaTableRowCollection rows = null;
	/** 是否存在分组行有索引条指示器（后期处理生成） */
	private Boolean indicator = false;
	/** 是否存在分组行有组头悬停（后期处理生成） */
	private Boolean hoverHead = false;
	/** 列表行插入删除动画*/
	private String itemAnim = ItemAnimType.FADEIN;
	/** 布局动画 */
	private String layoutAnim;

	/**
	 * 获取显示索引条指示器
	 *
	 * @return 是否显示索引条指示器，默认值为{@link #indicator}
	 */
	public Boolean isIndicator() {
		return indicator;
	}

	/**
	 * 设置显示索引条指示器
	 *
	 * @param indicator 是否显示索引条指示器，默认值为{@link #indicator}
	 */
	public void setIndicator(Boolean indicator) {
		this.indicator = indicator;
	}

	/**
	 * 获取显示组头悬停
	 *
	 * @return 是否显示组头悬停，默认值为{@link #hoverHead}
	 */
	public Boolean isHoverHead() {
		return hoverHead;
	}

	/**
	 * 设置显示组头悬停
	 *
	 * @param hoverHead 是否显示组头悬停，默认值为{@link #hoverHead}
	 */
	public void setHoverHead(Boolean hoverHead) {
		this.hoverHead = hoverHead;
	}


	/**
	 * 取得列表行插入删除动画
	 *
	 * @return 列表行插入删除动画，取值范围为{@link RecyclerViewAnimHelper}，默认值为{@link #itemAnim}
	 */
	public String getItemAnim() {
		return itemAnim;
	}

	/**
	 * 设置列表行插入删除动画
	 *
	 * @param itemAnim 列表行插入删除动画，取值范围为{@link RecyclerViewAnimHelper}，默认值为{@link #itemAnim}
	 */
	public void setItemAnim(String itemAnim) {
		this.itemAnim = itemAnim;
	}

	/**
	 * 取得布局动画
	 *
	 * @return 布局动画，取值范围为{@link LayoutAnimHelper}，默认值为{@link #layoutAnim}
	 */
	public String getLayoutAnim() {
		return layoutAnim;
	}

	/**
	 * 设置布局动画
	 *
	 * @param layoutAnim 布局动画，取值范围为{@link LayoutAnimHelper}，默认值为{@link #layoutAnim}
	 */
	public void setLayoutAnim(String layoutAnim) {
		this.layoutAnim = layoutAnim;
	}

	@Override
	public int getControlType() {
		return ControlType.TABLEVIEW;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] { rows });
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public MetaTableView newInstance() {
		return new MetaTableView();
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);

		if ( resultMetaObject == null ) {
			if ( MetaTableRowCollection.TAG_NAME.equals(tagName) ) {
				this.rows = new MetaTableRowCollection();
				resultMetaObject = this.rows;
			}
		}
		return resultMetaObject;
	}
	
	public MetaTableRowCollection getRows() {
		return rows;
	}
	
	public void setRows(MetaTableRowCollection rows) {
		this.rows = rows;
	}

	@Override
	public MetaTableView clone() {
		MetaTableView newObject = (MetaTableView) super.clone();
		newObject.setRows(rows == null ? null: (MetaTableRowCollection)rows.clone());
		newObject.setIndicator(indicator);
		newObject.setHoverHead(hoverHead);
		newObject.setItemAnim(itemAnim);
		newObject.setLayoutAnim(layoutAnim);
		return newObject;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (rows != null) {
			boolean hasIndicatorGroupRow = false;
			boolean hasHoverHeadGroupRow = false;
			for (int i = 0, size = rows.size(); i < size; i++) {
				MetaTableRow element = rows.get(i);
				if(element.getRowType() == TableViewRowType.Group) {
					int nextIndex = i + 1;
					if(nextIndex == size || rows.get(nextIndex).getRowType() !=
							TableViewRowType.Detail) {
						element.setRowType(TableViewRowType.Fix);
					} else {
						if (element.isIndicator()) {
							if (hasIndicatorGroupRow) {
								throw new MetaException( MetaException.TABLE_VIEW_ONLY_ALLOW_ONE_GROUP_ROW_HAS_INDICATOR,
										SimpleStringFormat.format(StringTable.getString(null, "", 
												StringTable.TableViewOnlyAllowOneGroupRowHasIndicator), this.getKey()));
							}
							hasIndicatorGroupRow = true;
						}
						if (element.isHoverHead()) {
							hasHoverHeadGroupRow = true;
						}
						element.setTableKey(rows.get(nextIndex).getTableKey());
					}
				} else if(element.getRowType() == TableViewRowType.GroupTail) {
					int beforeIndex = i - 1;
					if(beforeIndex < 0 || rows.get(beforeIndex).getRowType() !=
							TableViewRowType.Detail) {
						element.setRowType(TableViewRowType.Fix);
					} else {
						element.setTableKey(rows.get(beforeIndex).getTableKey());
					}
				}
				element.doPostProcess(flag, callback);
			}

			indicator = hasIndicatorGroupRow;
			hoverHead = hasHoverHeadGroupRow;
		}
	}
}
