package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.ProgressBarStyleType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaProgressBarProperties extends GenericNoKeyCollection<MetaProgressBarItem> implements IPropertyMerger<MetaProgressBarProperties>{

	public static final int DEFAULT_MAX_POS = 100;
	public static final int DEFAULT_STEP_VALUE = 1;
	
	/** Bar默认颜色默认值 */
	public static final String DEFAULT_BAR_COLOR = "#dddddd";
	
	/** Bar进度颜色默认值 */
	public static final String DEFAULT_PROGRESS_COLOR = "#00aaee";
	
	/** 最大的进度值*/
	private Integer maxPos = DEFAULT_MAX_POS;
	/** 最小的进度值*/
	private Integer minPos = 0;
	/** 步进值，0或负值代表没有步进*/
	private Integer stepValue = DEFAULT_STEP_VALUE;
	/** 进度显示动效*/
	private Boolean dynamic = false;
	/** 默认颜色*/
	private String barColor = DEFAULT_BAR_COLOR;
	/** 进度颜色*/
	private String progressColor = DEFAULT_PROGRESS_COLOR;
	/** 进度显示样式*/
	private Integer style = ProgressBarStyleType.Horizontal;
	/** 是否循环显示进度*/
	private Boolean repeat = false;
	
	/**
	 * 获取最大进度值
	 * @return 最大进度值
	 */
	public Integer getMaxPos() {
		return maxPos;
	} 
	
	/**
	 * 设置最大进度值
	 * @param maxPos 最大进度值
	 */
	public void setMaxPos(Integer maxPos) {
		this.maxPos = maxPos;
	}
	
	/**
	 * 设置最小进度值
	 * @return 最小进度值
	 */
	public Integer getMinPos() {
		return minPos;
	}
	
	/**
	 * 设置最小进度值
	 * @param minPos 最小进度值
	 */
	public void setMinPos(Integer minPos) {
		this.minPos = minPos;
	}
	
	/**
	 * 获取步进值
	 * @return 步进值，为0或者负值代表没有步进。
	 */
	public Integer getStepValue() {
		return stepValue;
	}
	
	/**
	 * 设置步进值
	 * @param stepValue 步进值，为0或者负值代表没有步进。
	 */
	public void setStepValue(Integer stepValue) {
		this.stepValue = stepValue;
	}
	
	/**
	 * 是否显示进度动效
	 * @return 是否显示进度动效
	 */
	public Boolean isDynamic() {
		return dynamic;
	}
	
	/**
	 * 设置是否显示进度动效
	 * @param dynamic 是否显示进度动效
	 */
	public void setDynamic(Boolean dynamic) {
		this.dynamic = dynamic;
	}
	
	/**
	 * 获取进度条颜色
	 * @return 进度条颜色
	 */
	public String getBarColor() {
		return barColor;
	}
	
	/**
	 * 设置进度条颜色
	 * @param barColor 进度条颜色
	 */
	public void setBarColor(String barColor) {
		this.barColor = barColor;
	}
	
	/**
	 * 获取进度刻度颜色
	 * @return 进度刻度颜色
	 */
	public String getProgressColor() {
		return progressColor;
	}
	
	/**
	 * 设置进度刻度颜色
	 * @param progressColor 进度刻度颜色
	 */
	public void setProgressColor(String progressColor) {
		this.progressColor = progressColor;
	}
	
	/**
	 * 获取进度条显示样式
	 * @return 进度条显示样式，参考{@link ProgressBarStyleType}
	 */
	public Integer getStyle() {
		return style;
	}
	
	/**
	 * 设置进度条显示样式
	 * @param style 进度条显示样式，参考{@link ProgressBarStyleType}
	 */
	public void setStyle(Integer style) {
		this.style = style;
	}
	
	/**
	 * 是否循环显示进度
	 * @return 是否循环显示进度
	 */
	public Boolean isRepeat() {
		return repeat;
	}
	
	/**
	 * 设置是否循环显示进度
	 * @param repeat 是否循环显示进度
	 */
	public void setRepeat(Boolean repeat) {
		this.repeat = repeat;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(maxPos <= minPos){
			throw new MetaException(MetaException.COMPONENT_MAX_NOT_GREATER_THAN_MIN, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ComponentMaxNotGreaterThanMin), ControlType.STR_PROGRESSBAR));
		}
		if(stepValue < 0){
			throw new MetaException(MetaException.COMPONENT_STEP_LESS_THAN_ZERO, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ComponentStepLessThanZero), ControlType.STR_PROGRESSBAR));
		}else if(stepValue > 0 && ((maxPos - minPos) % stepValue) != 0){
			throw new MetaException(MetaException.COMPONENT_RANGE_CAN_NOT_BE_DIVISIBLE_BY_STEP, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ComponentRangeCannotBeDividedByStep), ControlType.STR_PROGRESSBAR));
		}
		
		for (MetaProgressBarItem metaProgressItem : elementArray) {
			if (metaProgressItem.getStartPos() < minPos) {
				metaProgressItem.setStartPos(minPos);
			}
			if (metaProgressItem.getStartPos() > maxPos) {
				metaProgressItem.setStartPos(maxPos);
			}
			if (metaProgressItem.getEndPos() > maxPos) {
				metaProgressItem.setEndPos(maxPos);
			}
			if (metaProgressItem.getStartPos() > metaProgressItem.getEndPos()) {
				metaProgressItem.setEndPos(metaProgressItem.getStartPos());
			}
		}
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if ( tagName.equals(MetaProgressBarItem.TAG_NAME)) {
			child = new MetaProgressBarItem();
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((MetaProgressBarItem) child);
		} 
		return child;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaProgressBarProperties newObj = (MetaProgressBarProperties) super.clone();
		newObj.setBarColor(barColor);
		newObj.setDynamic(dynamic);
		newObj.setMaxPos(maxPos);
		newObj.setMinPos(minPos);
		newObj.setProgressColor(progressColor);
		newObj.setStepValue(stepValue);
		newObj.setStyle(style);
		newObj.setRepeat(repeat);
		return newObj;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProgressBarProperties();
	}
	
	@Override
	public void merge(MetaProgressBarProperties newProperties) {
		if(barColor == null){
			barColor = newProperties.getBarColor();
		}
		if(dynamic == null){
			dynamic = newProperties.isDynamic();
		}
		if(maxPos == -1){
			maxPos = newProperties.getMaxPos();
		}
		if(minPos == -1){
			minPos = newProperties.getMinPos();
		}
		if(progressColor == null){
			progressColor = newProperties.getProgressColor();
		}
		if(stepValue == -1){
			stepValue = newProperties.getStepValue();
		}
		if(style == -1){
			style = newProperties.getStyle();
		}
		if(repeat == null){
			repeat = newProperties.isRepeat();
		}
	}
	
}
