package com.bokesoft.yigo.meta.form.component.control.properties;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.PasswordEditorStyle;

public class MetaPasswordEditorProperties extends MetaTextEditorProperties{

	/** 是否使用自定义安全软键盘 */
	private Boolean safeInput = false;
	
	/** 是否显示切换文本样式（明文或密文）图标*/
	private Boolean showSwitchIcon = true;
	
	/** 样式 */
	private Integer style = PasswordEditorStyle.NORMAL;
	
	/** 初始是否显示明文 */
	private Boolean showPlainText = false;
	
	/** 方框和下划线样式的间距 */
	private DefSize spacing = DefSize.parse("0dp");

	/**
	 * 获取是否使用自定义安全软键盘
	 * 
	 * @return 是否使用自定义安全软键盘
	 */
	public Boolean isSafeInput() {
		return safeInput;
	}

	/**
	 * 设置是否使用自定义安全软键盘
	 * 
	 * @param safeInput 是否使用自定义安全软键盘
	 */
	public void setSafeInput(Boolean safeInput) {
		this.safeInput = safeInput;
	}

	/**
	 * 获取是否显示切换文本样式（密码或明文）按钮
	 * 
	 * @return 是否显示切换文本样式（密码或明文）按钮
	 */
	public Boolean isShowSwitchIcon() {
		return showSwitchIcon;
	}
	
	/**
	 * 设置是否显示切换文本样式（密码或明文）按钮
	 * 
	 * @param showSwitchIcon 是否显示切换文本样式（密码或明文）按钮
	 */
	public void setShowSwitchIcon(Boolean showSwitchIcon) {
		this.showSwitchIcon = showSwitchIcon;
	}
	
	/** 获取样式 
	 * 
	 * @return 样式
	 */
	public Integer getStyle() {
		return style;
	}
	
	/**
	 * 设置样式
	 * 
	 * @param style 样式
	 */
	public void setStyle(Integer style) {
		this.style = style;
	}
	
	/**
	 * 获取初始是否显示明文
	 * 
	 * @return 初始是否显示明文
	 */
	public Boolean isShowPlainText() {
		return showPlainText;
	}
	
	/**
	 * 设置初始是否显示明文
	 * 
	 * @param showPlainText 初始是否显示明文
	 */
	public void setShowPlainText(Boolean showPlainText) {
		this.showPlainText = showPlainText;
	}
	
	/**
	 * 获取方框和下划线样式的间距
	 * 
	 * @return 方框和下划线样式的间距
	 */
	public DefSize getSpacing() {
		return spacing;
	}
	
	/**
	 * 设置方框和下划线样式的间距
	 * 
	 * @param spacing 方框和下划线样式的间距
	 */
	public void setSpacing(DefSize spacing) {
		this.spacing = spacing;
	}
	
	
	@Override
	public AbstractMetaObject clone() {
		MetaPasswordEditorProperties newObj = (MetaPasswordEditorProperties) super.clone();
		newObj.setSafeInput(safeInput);
		newObj.setShowSwitchIcon(showSwitchIcon);
		newObj.setShowPlainText(showPlainText);
		newObj.setStyle(style);
		newObj.setSpacing(spacing);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPasswordEditorProperties();
	}
	
	@Override
	public void merge(MetaTextEditorProperties properties) {
		super.merge(properties);
		if(safeInput == null){
			safeInput = ((MetaPasswordEditorProperties)properties).isSafeInput();
		}
		if(showSwitchIcon == null){
			showSwitchIcon = ((MetaPasswordEditorProperties)properties).isShowSwitchIcon();
		}
		if(style == -1){
			style = ((MetaPasswordEditorProperties)properties).getStyle();
		}
		if(showPlainText == null){
			showPlainText = ((MetaPasswordEditorProperties)properties).isShowPlainText();
		}
		if(spacing == null){
			spacing = ((MetaPasswordEditorProperties)properties).getSpacing();
		}
	}
}
