package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.LabelLineBreakType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaLabelProperties extends AbstractMetaObject implements IPropertyMerger<MetaLabelProperties>{
	/** 图标路径 */
	private String icon = "";
	/** 是否为单行*/
	private Boolean singleLine = true;
	/** 文本超出组件大小后的截断类型*/
	private Integer lineBreakMode = LabelLineBreakType.ENDHIDE;
	/** 最大行数,优先级低于singleLine**/
	private Integer maxLines = -1;
	/** 文本过长时是否需要展开收缩功能，该值为“展开，收缩”这样的字符串，
	 * 逗号前为收缩时显示文本，逗号后为展开时显示文本；该值不为空时，展开收缩功能才其效果*/
	private String expandCaption = "";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}
	
	/**
	 * 设置图标路径
	 * @param icon 图标路径
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 取得图标路径
	 * @return 图标路径
	 */
	public String getIcon() {
		return this.icon;
	}
	
	/**
	 * 是否为单行显示
	 * @return 是否为单行显示
	 */
	public Boolean isSingleLine() {
		return singleLine;
	}

	/**
	 * 设置是否为单行显示
	 * @param singleLine 是否为单行显示
	 */
	public void setSingleLine(Boolean singleLine) {
		this.singleLine = singleLine;
	}

	/**
	 * 获取截断类型
	 * @return 截断类型
	 */
	public Integer getLineBreakMode() {
		return lineBreakMode;
	}

	/**
	 * 设置截断类型
	 * @param lineBreakMode 截断类型
	 */
	public void setLineBreakMode(Integer lineBreakMode) {
		this.lineBreakMode = lineBreakMode;
	}
	
	/**
	 * 获取最大行数
	 * @return 最大行数
	 */
	public Integer getMaxLines() {
		return maxLines;
	}
	
	/**
	 * 设置最大行数
	 * @param maxLines 最大行数
	 */
	public void setMaxLines(Integer maxLines) {
		this.maxLines = maxLines;
	}
	
	/**
	 * 获取收缩展开功能显示文本
	 * @return 显示文本
	 */
	public String getExpandCaption() {
		return expandCaption;
	}
	
	/**
	 * 设置收缩展开功能显示文本
	 * @param expandCaption 显示文本
	 */
	public void setExpandCaption(String expandCaption) {
		this.expandCaption = expandCaption;
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaLabelProperties newObject = new MetaLabelProperties();
		newObject.setIcon(icon);
		newObject.setSingleLine(singleLine);
		newObject.setLineBreakMode(lineBreakMode);
		newObject.setMaxLines(maxLines);
		newObject.setExpandCaption(expandCaption);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLabelProperties();
	}

	@Override
	public void merge(MetaLabelProperties properties) {
		if( this.icon == null ) {
			this.icon = properties.getIcon();
		}
		if( this.singleLine == null){
			this.singleLine = properties.isSingleLine();
		}
		if(this.lineBreakMode == null){
			this.lineBreakMode = properties.getLineBreakMode();
		}
		if(this.maxLines == null){
			this.maxLines = properties.getMaxLines();
		}
		if(this.expandCaption == null){
			this.expandCaption = properties.getExpandCaption();
		}
	}

}
