package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.common.struct.syspara.ParaTable;
import com.bokesoft.yigo.common.struct.syspara.ParaTableCollection;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;

public class MetaDictProperties extends AbstractMetaObject implements IPropertyMerger<MetaDictProperties>{
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/** 字典标识 */
	private String itemKey = "";

	/** 字典显示的根节点 */
	private String root = "";

	/** 是否为动态字典 */
	private Boolean isDynamic = false;

	/** 是否允许多选 */
	private Boolean isAllowMultiSelection = false;

	/** 父子节点联动,默认联动*/
	private Boolean independent = false;

	/** 是否是复合字典 */
	private Boolean isCompDict = false;

	/** 动态字典ItemKey关联字段*/
	private String refKey = null;

	/** 动态字典数据元素的关联字段*/
	private String refDataElementKey = null;

	/** 字典状态过滤,-1代表未定义*/
	private Integer stateMask = DictStateMask.Enable;
	/** 字典状态过滤表达式 */
	private String stateMaskFormula = null;
	/** 字典过滤条件 */
	private MetaItemFilterCollection filters = null;

	/** itemKey来源类型,-1表示未定义*/
	private Integer itemKeySourceType = DictItemKeySourceType.DATAOBJECT;

	/** 当itemKeySourceType为Para时 取的itemKey的值*/
	private String itemKeySource = "";

	/** 忽略数据权限 */
	private Boolean ignoreRights = false;

	/** 编辑类型*/
	private Integer editType = SelectEditType.SIDESLIP;

	/** 是否允许编辑输入框，只有在enable为true，onlyShow为false的情况下有效*/
	private Boolean editable = true;

	/**    字典加载策略 -1 代表未定义*/
	private Integer loadType = DictLoadType.R2L;

	/** 表达式显示值 */
	private String formulaText = "";

	/** 显示字段（DataObject中定义的columnKey 需添加为缓存字段）*/
	private String textField = "";

	/** 字典编辑器为空时的提示信息 */
	private String promptText = "";

	/** 单选字典文本框输入数据是否出现相对应数据，默认显示*/
	private Boolean isPromptData = false;


	/** 是否禁用软键盘，针对带有输入框的组件*/
	private Boolean disableKeyboard;

	/** 模糊查询匹配方式*/
	private Integer queryMatchType = DictQueryMatchType.Full;
	private String browserFormKey = null;
	private Boolean editValue = false;

	public MetaDictProperties() {
		super();
	}

	/**
	 * 设置字典根节点
	 * @param root 字典根节点
	 */
	public void setRoot(String root) {
		this.root = root;
	}

	/**
	 * 获取字典根节点
	 * @return 字典根节点
	 */
	public String getRoot() {
		return this.root;
	}

	/**
	 * 设置动态字典ItemKey的关联字段
	 * @param key 字段标识
	 */
	public void setRefKey(String key) {
		this.refKey = key;
	}

	/**
	 * 获取动态字典ItemKey的关联字段
	 * @return 字段标识
	 */
	public String getRefKey() {
		return this.refKey;
	}


	/**
	 * 设置动态字典数据元素的关联字段
	 * @param key 字段标识
	 */
	public void setRefDataElementKey(String key) {
		this.refDataElementKey = key;
	}

	/**
	 * 获取动态字典数据元素的关联字段
	 * @return 字段标识
	 */
	public String getRefDataElementKey() {
		return this.refDataElementKey;
	}

	/**
	 * 设置是否为动态字典
	 *
	 * @param isDynamic
	 *            是否为动态字典
	 */
	public void setDynamic(Boolean isDynamic) {
		this.isDynamic = isDynamic;
	}

	/**
	 * 获取是否为动态字典
	 *
	 * @return 是否为动态字典
	 */
	public Boolean isDynamic() {
		return this.isDynamic;
	}

	/**
	 * 设置字典关联对象的标识
	 *
	 * @param key
	 *            关联对象标识
	 */
	public void setItemKey(String key) {
		this.itemKey = key;
	}

	/**
	 * 获取字典关联对象的标识
	 *
	 * @return 关联对象标识
	 */
	public String getItemKey() {
		return this.itemKey;
	}

	/**
	 * 设置是否允许多选
	 *
	 * @param allow
	 *            是否允许多选
	 */
	public void setAllowMultiSelection(Boolean allow) {
		this.isAllowMultiSelection = allow;
	}

	/**
	 * 获取是否允许多选
	 *
	 * @return 是否允许多选
	 */
	public Boolean isAllowMultiSelection() {
		return this.isAllowMultiSelection;
	}

	/**
	 * 设置是否父子节点联动
	 *
	 * @param independent
	 *            是否父子节点联动
	 */
	public void setIndependent(Boolean independent) {
		this.independent = independent;
	}

	/**
	 * 获取是否父子节点联动
	 *
	 * @return 是否为父子节点联动
	 */
	public Boolean isIndependent() {
		return this.independent;
	}

	/**
	 * 设置状态过滤
	 * @param stateMask 状态过滤
	 */
	public void setStateMask(Integer stateMask){
		this.stateMask = stateMask;
	}

	/**
	 * 获取状态过滤
	 * @return 状态过滤
	 */
	public Integer getStateMask(){
		return this.stateMask;
	}

	/**
	 * 设置状态过滤表达式
	 * @param s 状态过滤表达式
	 */
	public void setStateMaskFormula(String s) {
		this.stateMaskFormula = s;
	}
	
	/**
	 * 获取状态过滤表达式
	 * @return 状态过滤表达式
	 */
	public String getStateMaskFormula() {
		return this.stateMaskFormula;
	}
	/**
	 * 设置是否是是否是复合字典
	 * @param isCompDict 标志
	 */
	public void setCompDict(Boolean isCompDict) {
		this.isCompDict = isCompDict;
	}

	/**
	 * 获取是否是复合字典
	 * @return 是否复合字典标志
	 */
	public Boolean isCompDict(){
		return this.isCompDict;
	}

	/**
	 * 设置过滤条件
	 * @param filters 过滤条件
	 */
	public void setFilters(MetaItemFilterCollection filters) {
		this.filters = filters;
	}

	/**
	 * 取得过滤条件
	 * @return 过滤条件
	 */
	public MetaItemFilterCollection getFilters() {
		return this.filters;
	}

	/**
	 * 设置字典标识来源类型
	 * @param type 字典标识来源类型
	 */
	public void setItemKeySourceType(Integer type){
		this.itemKeySourceType = type;
	}

	/**
	 * 获取字典标识来源类型
	 * @return 字典标识来源类型
	 */
	public Integer getItemKeySourceType(){
		return this.itemKeySourceType;
	}

	/**
	 * 设置字典标识来源
	 * @param s 字典标识来源
	 */
	public void setItemKeySource(String s){
		this.itemKeySource = s;
	}

	/**
	 * 获取字典标识来源
	 * @return 字典标识来源
	 */
	public String getItemKeySource(){
		return this.itemKeySource;
	}

	/**
	 * 设置是否忽略权限
	 * @param ignoreRights 标志
	 */
	public void setIgnoreRights(Boolean ignoreRights) {
		this.ignoreRights = ignoreRights;
	}

	/**
	 * 获取是否忽略权限
	 * @return 是否忽略权限
	 */
	public Boolean isIgnoreRights(){
		return this.ignoreRights;
	}

	public String getBrowserFormKey() {
		return browserFormKey;
	}

	public void setBrowserFormKey(String browserFormKey) {
		this.browserFormKey = browserFormKey;
	}

	public Boolean isEditValue() {
		return editValue;
	}

	public void setEditValue(Boolean editValue) {
		this.editValue = editValue;
	}

	public void setEditType(Integer editType) {
		this.editType = editType;
	}

	public Integer getEditType() {
		return editType;
	}

	public void setEditable(Boolean editable) {
		this.editable = editable;
	}

	public Boolean isEditable() {
		return editable;
	}

	/**
	 * 设置加载策略
	 * @param type 加载策略
	 */
	public void setLoadType(Integer type){
		this.loadType = type;
	}

	/**
	 * 获取加载策略
	 * @return 加载策略
	 */
	public Integer getLoadType(){
		return this.loadType;
	}

	/**
	 * 设置模糊查询方式
	 * @param type 模糊查询匹配方式
	 */
	public void setQueryMatchType(Integer type){
		this.queryMatchType = type;
	}

	/**
	 * 获取模糊查询匹配方式
	 * @return 模糊查询匹配方式
	 */
	public Integer getQueryMatchType(){
		return this.queryMatchType;
	}

	/**
	 * 表达式显示值
	 * @param s 表达式显示值
	 */
	public void setFormulaText(String s){
		this.formulaText = s;
	}

	/**
	 * 获取表达式显示值
	 * @return 表达式显示值
	 */
	public String getFormulaText(){
		return this.formulaText;
	}

	/**
	 * 字典控件文本显示字段
	 * @param s 显示字段
	 */
	public void setTextField(String s){
		this.textField = s;
	}

	/**
	 * 获取字典控件文本显示字段
	 * @return 文本显示字段
	 */
	public String getTextField(){
		return this.textField;
	}

	/**
	 * 设置字典为空时的提示信息
	 *
	 * @param promptText
	 *            提示信息
	 */
	public void setPromptText(String promptText) {
		this.promptText = promptText;
	}

	/**
	 * 获取字典为空时的提示信息
	 *
	 * @return 提示信息
	 */
	public String getPromptText() {
		return this.promptText;
	}

	/**
	 * 获取是否显示相对应数据行
	 *
	 * @return  是否显示相对应数据行
	 */
	public Boolean isPromptData() {
		return isPromptData;
	}

	/**
	 * 设置是否显示相对应数据行
	 *
	 * @param isPromptData
	 * 			是否显示相对应数据行
	 */
	public void setPromptData(Boolean isPromptData) {
		this.isPromptData = isPromptData;
	}

	/**
	 * 设置是否禁用软键盘，针对带有输入框的组件
	 * @param disableKeyboard 是否禁用软键盘
	 */
	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.disableKeyboard = disableKeyboard;
	}

	/**
	 * 获取是否禁用软键盘，针对带有输入框的组件
	 * @return 是否禁用软键盘
	 */
	public Boolean isDisableKeyboard() {
		return disableKeyboard;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( this.filters != null ) {
			filters.getChildMetaObjects(list);
		}
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if( MetaItemFilter.TAG_NAME.equals(tagName) ) {
			if(filters == null){
				filters = new MetaItemFilterCollection();
			}
			resultMetaObject = filters.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDictProperties newObject = new MetaDictProperties();
		newObject.setDynamic(isDynamic);
		newObject.setRefKey(refKey);
		newObject.setRefDataElementKey(refDataElementKey);
		newObject.setItemKey(itemKey);
		newObject.setAllowMultiSelection(isAllowMultiSelection);
		newObject.setIndependent(independent);
		newObject.setCompDict(isCompDict);
		newObject.setRoot(root);
		newObject.setIgnoreRights(ignoreRights);
		newObject.setFilters(filters == null ? null : (MetaItemFilterCollection)filters.clone());
		newObject.setItemKeySource(itemKeySource);
		newObject.setItemKeySourceType(itemKeySourceType);
		newObject.setStateMask(stateMask);
		newObject.setStateMaskFormula(stateMaskFormula);
		newObject.setEditType(editType);
		newObject.setEditable(editable);
		newObject.setLoadType(loadType);
		newObject.setTextField(textField);
		newObject.setFormulaText(formulaText);
		newObject.setPromptText(promptText);
		newObject.setPromptData(isPromptData);
		newObject.setDisableKeyboard(disableKeyboard);
		newObject.setQueryMatchType(queryMatchType);
		newObject.setBrowserFormKey(browserFormKey);
		newObject.setEditValue(editValue);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDictProperties();
	}

	public void calItemKey(String projectKey) throws Throwable {
		if(this.itemKeySourceType == DictItemKeySourceType.PARA){
			String[] s = this.itemKeySource.split("[.]");
			MetaParaTable paraTable = MetaFactory.getGlobalInstance().getParaTable();
			this.itemKey = paraTable.get(s[0]).get(s[1]).getValue();;
		}
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		if( filters != null ) {
			String itemKey = null;
			for( MetaItemFilter itemFilter : filters ) {
				itemKey = itemFilter.getItemKey();
				if( itemKey == null || itemKey.isEmpty() ) {
					itemFilter.setItemKey(this.itemKey);
				}
			}
		}
		try {
			if(callback != null){
				callback.call(this);
			}
		} catch (Throwable e) {
			e.printStackTrace();
			throw new MetaException(MetaException.ITEMKEY_ERROR, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ItemKeyError)));
		}
	}

	@Override
	public void merge(MetaDictProperties properties) {
		if( this.itemKey == null ) {
			this.itemKey = properties.getItemKey();
		}
		if( this.browserFormKey == null ) {
			this.browserFormKey = properties.getBrowserFormKey();
		}
		if( this.editValue == null ) {
			this.editValue = properties.isEditValue();
		}
		if( this.root == null ) {
			this.root = properties.getRoot();
		}
		if( this.isDynamic == null ) {
			this.isDynamic = properties.isDynamic();
		}
		if( this.isAllowMultiSelection == null ) {
			this.isAllowMultiSelection = properties.isAllowMultiSelection();
		}
		if( this.independent == null ) {
			this.independent = properties.isIndependent();
		}
		if( this.isCompDict == null ) {
			this.isCompDict = properties.isCompDict();
		}
		if( this.refKey == null ) {
			this.refKey = properties.getRefKey();
		}
		if( this.refDataElementKey == null ) {
			this.refDataElementKey = properties.getRefDataElementKey();
		}
		if( this.itemKeySourceType == -1 ) {
			this.itemKeySourceType = properties.getItemKeySourceType();
		}
		if( this.itemKeySource == null ) {
			this.itemKeySource = properties.getItemKeySource();
		}
		if( this.stateMask == -1 ) {
			this.stateMask = properties.getStateMask();
		}
		if(this.stateMaskFormula == null) {
			this.stateMaskFormula = properties.getStateMaskFormula();
		}
		if( this.ignoreRights == null){
			this.ignoreRights = properties.isIgnoreRights();
		}
		if( this.loadType == -1 ){
			this.loadType = properties.getLoadType();
		}
		if( this.filters == null ) {
			MetaItemFilterCollection filters = properties.getFilters();
			if( filters != null ) {
				this.filters = (MetaItemFilterCollection) filters.depthClone();
			}
		} else {
			MetaItemFilterCollection filters = properties.getFilters();
			if( filters != null ) {
				for (MetaItemFilter filter : filters) {
					MetaItemFilter metaItemFilter = this.filters.get(filter.getItemKey());
					if (metaItemFilter == null){
						this.filters.add(filter);
					}else {
						metaItemFilter.merge(filter);
					}
				}
			}
		}

		if( this.textField == null){
			this.textField = properties.getTextField();
		}

		if( this.formulaText == null){
			this.formulaText = properties.getFormulaText();
		}
		if( this.promptText == null ) {
			this.promptText = properties.getPromptText();
		}
		if( this.isPromptData == null){
			this.isPromptData = properties.isPromptData();
		}
		if( this.disableKeyboard == null){
			this.disableKeyboard = properties.isDisableKeyboard();
		}
		if( this.queryMatchType == -1) {
			this.queryMatchType = properties.getQueryMatchType();
		}
	}
}
