package com.bokesoft.yigo.meta.form.component.control.progressindicator;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 进度刻度项对象集合
 * @author chenzs
 *
 */
public class MetaProgressItemCollection extends GenericKeyCollection<MetaProgressItem> {

	public static final String TAG_NAME = "ProgressItemCollection";
 
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject object = null;
		if (tagName.equalsIgnoreCase(MetaProgressItem.TAG_NAME)) {
			MetaProgressItem item = new MetaProgressItem();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			object = item;
		}
		return object;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProgressItemCollection();
	}

	@Override
	public AbstractMetaObject clone() {
		return super.clone();
	}

	@Override
	public boolean needPreLoad() {
		return true;
	}
}
