package com.bokesoft.yigo.meta.form.component.control.progressindicator;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 进度指示器条目对象
 * @author chenzs
 *
 */
public class MetaProgressItem extends KeyPairMetaObject{

	public static final String TAG_NAME = "ProgressItem";
	
	/** 条目标识 */
	private String key = "";
	/** 条目名称 */
	private String caption = "";
	/** 条目标题 */
	private String title = "";
	/** 条目内容*/
	private String message = "";
	/** 条目先后时间*/
	private String dateTime = "";
	
	/**
	 * 设置条目标识
	 * @param key 条目标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return key;
	}
	
	/**
	 * 获取条目名称
	 * @return 条目名称
	 */
	public String getCaption() {
		return caption;
	}
	
	/**
	 * 设置条目名称
	 * @param caption 条目名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 设置条目标题
	 * @param title 条目标题
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	
	/**
	 * 获取条目标题
	 * @return 条目标题
	 */
	public String getTitle() {
		return title;
	}
	
	/**
	 * 设置条目内容
	 * @param message 条目内容
	 */
	public void setMessage(String message) {
		this.message = message;
	}
	
	/**
	 * 获取条目内容
	 * @return 条目内容
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * 设置条目时间
	 * @param dateTime 条目时间
	 */
	public void setDateTime(String dateTime) {
		this.dateTime = dateTime;
	}
	
	/**
	 * 获取条目时间
	 * @return 条目时间
	 */
	public String getDateTime() {
		return dateTime;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaProgressItem newObj = (MetaProgressItem)newInstance();
		newObj.setKey(key);
		newObj.setCaption(caption);
		newObj.setTitle(title);
		newObj.setMessage(message);
		newObj.setDateTime(dateTime);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProgressItem();
	}
	
}
