package com.bokesoft.yigo.meta.form.component.control.moduleeditor;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.ModuleSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaModuleEditor extends MetaComponent {

	public static final String TAG_NAME = "ModuleEditor";
	
	/** 模块来源类型 */
	private Integer sourceType = ModuleSourceType.ITEMS;
	/** 模块来源标题 */
	private String sourceCaption = "";
	/** 模块保存数据表标识 */
	private String tableKey = "";
	/** 模块来源数据表标识 */
	private String sourceTableKey = "";
	/** 模块排布列数 */
	private Integer columnCount = 5;
	/** 模块之间的间隔 */
	private Integer gap = 5;

	/** 模块固定项集合 */
	private MetaModuleItemCollection itemCollection = new MetaModuleItemCollection();
	/** 表达式表示的模块项集合 */
	private MetaBaseScript formulaItems = null;
	
	/**
	 * 获取模块来源类型
	 * @return 模块来源类型
	 */
	public Integer getSourceType() {
		return sourceType;
	}
	
	/**
	 * 设置模块来源类型
	 * @param sourceType 模块来源类型
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	/**
	 * 获取模块来源标题
	 * @return 模块来源标题
	 */
	public String getSourceCaption() {
		return sourceCaption;
	}
	
	/**
	 * 设置模块来源标题
	 * @param sourceCaption 模块来源标题
	 */
	public void setSourceCaption(String sourceCaption) {
		this.sourceCaption = sourceCaption;
	}
	 
	/**
	 * 模块保存数据表标识
	 * @return 模块保存数据表标识
	 */
	public String getTableKey() {
		return tableKey;
	}
	
	/**
	 * 设置模块保存数据表标识
	 * @param tableKey 模块保存数据表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 获取模块来源数据表标识
	 * @return 模块来源数据表标识
	 */
	public String getSourceTableKey() {
		return sourceTableKey;
	}
	
	/**
	 * 设置模块来源数据表标识
	 * @param sourceTableKey 模块来源数据表标识
	 */
	public void setSourceTableKey(String sourceTableKey) {
		this.sourceTableKey = sourceTableKey;
	}
	
	/**
	 * 获取模块排布列数
	 * @return 模块排布列数
	 */
	public Integer getColumnCount() {
		return columnCount;
	}
	
	/**
	 * 设置模块排布列数
	 * @param columnCount 模块排布列数
	 */
	public void setColumnCount(Integer columnCount) {
		this.columnCount = columnCount;
	}
	
	/**
	 * 获取模块之间的间隔
	 * @return 模块之间的间隔
	 */
	public Integer getGap() {
		return gap;
	}
	
	/**
	 * 设置模块之间的间隔
	 * @param gap 模块之间的间隔
	 */
	public void setGap(Integer gap) {
		this.gap = gap;
	}
	
	/**
	 * 获取模块固定项目集合
	 * @return 模块固定项目集合
	 */
	public MetaModuleItemCollection getItemCollection() {
		return itemCollection;
	}
	
	/**
	 * 设置模块固定项目集合
	 * @param itemCollection 模块固定项目集合
	 */
	public void setItemCollection(MetaModuleItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}
	
	/**
	 * 获取来源于公式的模块项目集合
	 * @return 来源于公式的模块项目集合
	 */
	public MetaBaseScript getFormulaItems() {
		return formulaItems;
	}
	
	/**
	 * 设置来源于公式的模块项目集合
	 * @param formulaItems 来源于公式的模块项目集合
	 */
	public void setFormulaItems(MetaBaseScript formulaItems) {
		this.formulaItems = formulaItems;
	}
	
	@Override
	public int getControlType() {
		return ControlType.MODULEEDITOR;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { itemCollection, formulaItems });
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = itemCollection.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			if ( MetaConstants.MODULEEDITOR_FORMULAITEMS.equals(tagName) ) {
				this.formulaItems = new MetaBaseScript(MetaConstants.MODULEEDITOR_FORMULAITEMS);
				resultMetaObject = formulaItems;
			} 
		}
		if(resultMetaObject == null){
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaModuleEditor();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaModuleEditor meta = (MetaModuleEditor)super.clone();
		meta.setSourceType(sourceType);
		meta.setSourceCaption(sourceCaption);
		meta.setSourceTableKey(sourceTableKey);
		meta.setTableKey(tableKey);
		meta.setColumnCount(columnCount);
		meta.setItemCollection(itemCollection == null ? null : (MetaModuleItemCollection)itemCollection.clone());
		meta.setFormulaItems(formulaItems == null ? null : (MetaBaseScript)formulaItems.clone());
		return meta;
	}
}
