package com.bokesoft.yigo.meta.form.component.control.gantt;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

import java.util.LinkedList;

/**
 * 甘特图中表的行
 */
public class MetaGanttRow extends KeyPairMetaObject {

	public static final String TAG_NAME = "GanttRow";

	/** 列标识 */
	private String key = "";

	/** 计划开始时间 */
	private String startTime = "";

	/** 计划结束时间 */
	private String endTime = "";

	/** 样式*/
	private String cssClass = "";

	/** 可见性表达式*/
	private String visible = "";

	/** 第一行尾部显示的文本*/
	private String text = "";

	/** 显示关系*/
	private Boolean showRelation = false;

	/** 形状*/
	private String shape = "";

	/**
	 * 获取形状
	 * @return
	 */
	public String getShape() {
		return shape;
	}

	/**
	 * 设置形状
	 * @param shape
	 */
	public void setShape(String shape) {
		this.shape = shape;
	}

	/**
	 * 设置列标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return this.key;
	}

	/**
	 * 获取尾部文本
	 * @return
	 */
	public String getText() {
		return text;
	}

	/**
	 * 设置尾部为本
	 * @param text
	 */
	public void setText(String text) {
		this.text = text;
	}

	/**
	 * 获取开始时间
	 *
	 * @return
	 */
	public String getStartTime() {
		return startTime;
	}

	/**
	 * 设置开始时间
	 *
	 * @param startTime
	 */
	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	/**
	 * 获取结束时间
	 *
	 * @return
	 */
	public String getEndTime() {
		return endTime;
	}

	/**
	 * 设置结束时间
	 *
	 * @param endTime
	 */
	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	/**
	 * 获取样式名
	 * @return
	 */
	public String getCssClass() {
		return cssClass;
	}

	/**
	 * 设置样式名
	 * @param cssClass
	 */
	public void setCssClass(String cssClass) {
		this.cssClass = cssClass;
	}

	/**
	 * 获取可见性
	 * @return
	 */
	public String getVisible() {
		return visible;
	}

	/**
	 * 设置可见性
	 * @param visible
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}

	/**
	 * 获取是否显示关系
	 * @return
	 */
	public Boolean getShowRelation() {
		return showRelation;
	}

	/**
	 * 设置是否显示关系
	 * @param showRelation
	 */
	public void setShowRelation(Boolean showRelation) {
		this.showRelation = showRelation;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGanttRow newObject = new MetaGanttRow();
		newObject.setKey(this.key);
		newObject.setStartTime(this.startTime);
		newObject.setEndTime(this.endTime);
		newObject.setCssClass(this.cssClass);
		newObject.setVisible(this.visible);
		newObject.setShowRelation(this.showRelation);
		newObject.setShape(this.shape);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGanttRow();
	}

	@Override
    public boolean needPreLoad() {
        return false;
    }
}
