package com.bokesoft.yigo.meta.form.component.control.gantt;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 甘特图图形数据来源
 */
public class MetaBaseShape extends AbstractMetaObject {

	public static final String TAG_NAME = "BaseShape";

	/** id */
	private String shapeId = "";
	
	/** 类型 */
	private String type = "";
	
	/** 显示文本 */
	private String title = "";

	/** 计划开始时间 */
	private String time = "";

	/** 计划结束时间 */
	private String endTime = "";
	
	/** 实际开始时间 */
	private String actualTime = "";
	
	/** 实际结束时间 */
	private String actualEndTime = "";

	/** 耗时 */
	private String duration = "";
	
	/** 进度 */
	private String progress = "";
	
	/** 父级 */
	private String parent = "";
	
	/**
	 * 获取显示文本
	 * 
	 * @return
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * 设置显示文本
	 * 
	 * @param title
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * 获取开始时间
	 * 
	 * @return
	 */
	public String getTime() {
		return time;
	}

	/**
	 * 设置开始时间
	 * 
	 * @param time
	 */
	public void setTime(String time) {
		this.time = time;
	}

	/**
	 * 获取结束时间
	 * 
	 * @return
	 */
	public String getEndTime() {
		return endTime;
	}

	/**
	 * 设置结束时间
	 * 
	 * @param endTime
	 */
	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	/**
	 * 获取实际开始时间
	 * 
	 * @return
	 */
	public String getActualTime() {
		return actualTime;
	}

	/**
	 * 设置实际开始时间
	 * 
	 * @param actualTime
	 */
	public void setActualTime(String actualTime) {
		this.actualTime = actualTime;
	}

	/**
	 * 获取实际结束时间
	 * 
	 * @return
	 */
	public String getActualEndTime() {
		return actualEndTime;
	}

	/**
	 * 设置实际结束时间
	 * 
	 * @param actualEndTime
	 */
	public void setActualEndTime(String actualEndTime) {
		this.actualEndTime = actualEndTime;
	}

	/**
	 * 获取id
	 * 
	 * @return
	 */
	public String getShapeId() {
		return shapeId;
	}

	/**
	 * 设置id
	 * 
	 * @param shapeId
	 */
	public void setShapeId(String shapeId) {
		this.shapeId = shapeId;
	}

	/**
	 * 获取类型
	 * 
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * 设置类型
	 * 
	 * @param type
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * 获取耗时
	 * 
	 * @return
	 */
	public String getDuration() {
		return duration;
	}

	/**
	 * 设置耗时
	 * 
	 * @param duration
	 */
	public void setDuration(String duration) {
		this.duration = duration;
	}

	/**
	 * 获取进度
	 * 
	 * @return
	 */
	public String getProgress() {
		return progress;
	}

	/**
	 * 设置进度
	 * 
	 * @param progress
	 */
	public void setProgress(String progress) {
		this.progress = progress;
	}

	/**
	 * 获取父id
	 * 
	 * @return
	 */
	public String getParent() {
		return parent;
	}

	/**
	 * 设置父id
	 * 
	 * @param parent
	 */
	public void setParent(String parent) {
		this.parent = parent;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBaseShape newObject = new MetaBaseShape();
		newObject.setTitle(this.title);
		newObject.setTime(this.time);
		newObject.setEndTime(this.endTime);
		newObject.setActualTime(this.actualTime);
		newObject.setActualEndTime(this.actualEndTime);
		newObject.setShapeId(this.shapeId);
		newObject.setDuration(this.duration);
		newObject.setProgress(this.progress);
		newObject.setParent(this.parent);
		newObject.setType(this.type);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBaseShape();
	}

}
