package com.bokesoft.yigo.meta.form.component.control.dictview;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaDictViewColumn extends KeyPairMetaObject implements IPropertyMerger<MetaDictViewColumn> {
	public static final String TAG_NAME = "DictViewColumn";

	/** 列的标识,数据源中缓存列的标识 */
	private String key = "";
	/** 列的名称 */
	private String caption = "";
	/** 列宽 */
	private DefSize width = null;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDictViewColumn newObject = new MetaDictViewColumn();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setWidth(width);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDictViewColumn();
	}

	/**
	 * 设置列标识
	 * 
	 * @param key
	 *            列标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得列标识
	 * 
	 * @return 列标识
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置列的名称
	 * 
	 * @param caption
	 *            列的名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 取得列的名称
	 * 
	 * @return 列的名称
	 */
	public String getCaption() {
		return caption;
	}
	
	/**
	 * 设置列宽
	 * 
	 * @param width
	 *            列宽
	 */
	public void setWidth(DefSize width) {
		this.width = width;
	}

	/**
	 * 取得列宽
	 * 
	 * @return 列宽
	 */
	public DefSize getWidth() {
		return width;
	}

	@Override
	public void merge(MetaDictViewColumn metaDictViewColumn) {

		if (this.caption == null) {
			this.caption = metaDictViewColumn.getCaption();
		}
		if (this.width == null) {
			this.width = metaDictViewColumn.getWidth();
		}


	}
}
