package com.bokesoft.yigo.meta.form.component.control.buttongroup;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaButtonGroup extends MetaComponent {
	private MetaButtonCollection buttonCollection = null;
	public MetaButtonGroup() {
		super();
	}
	
	public static final String TAG_NAME = ControlType.STR_BUTTON_GROUP;
	
	private String buttonType = "";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.BUTTON_GROUP;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			if ( MetaButtonCollection.TAG_NAME.equals(tagName) ) {
				buttonCollection = new MetaButtonCollection();
				resultMetaObject = buttonCollection;
			}
		}
		return resultMetaObject;
	}

	/**
	 * 设置按钮的集合
	 * @param buttonCollection 按钮集合
	 */
	public void setButtonCollection(MetaButtonCollection buttonCollection) {
		this.buttonCollection = buttonCollection;
	}
	
	/**
	 * 取得按钮的集合
	 * @return 按钮集合
	 */
	public MetaButtonCollection getButtonCollection() {
		return this.buttonCollection;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}
	
	public String getButtonType() {
		return buttonType;
	}

	public void setButtonType(String buttonType) {
		this.buttonType = buttonType;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaButtonGroup newObject = (MetaButtonGroup)super.clone();
		newObject.setButtonCollection(buttonCollection == null ? null : (MetaButtonCollection)buttonCollection.clone());
		newObject.setButtonType(buttonType);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaButtonGroup();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
}
