package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimeCountDownProperties;

public class MetaTimeCountDown extends MetaComponent{
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_TIMECOUNTDOWN;
	
	/** 属性对象*/
	private MetaTimeCountDownProperties metaProperties;
	
	public MetaTimeCountDown() {
		metaProperties = new MetaTimeCountDownProperties();
	}

	/**
	 * 设置属性对象
	 *
	 * @param metaProperties 属性对象
	 */
	@Override
	public void setProperties(AbstractMetaObject metaProperties) {
		this.metaProperties = (MetaTimeCountDownProperties) metaProperties;
	}
	
	@Override
	public int getControlType() {
		return ControlType.TIMECOUNTDOWN;
	}

	@Override
	public MetaTimeCountDownProperties getProperties() {
		return metaProperties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public MetaTimeCountDown newInstance() {
		return new MetaTimeCountDown();
	}

	@Override
	public MetaTimeCountDown clone() {
		MetaTimeCountDown metaObject = (MetaTimeCountDown)super.clone();
		metaObject.setProperties(metaProperties == null ? null : metaProperties.clone());
		return metaObject;
	}

	/**
	 * 获取计时结束事件
	 *
	 * @return 计时结束事件
	 */
	public MetaBaseScript getOnFinish() {
		return metaProperties.getOnFinish();
	}

	/**
	 * 设置计时结束事件
	 *
	 * @param onFinish 计时结束事件
	 */
	public void setOnFinish(MetaBaseScript onFinish) {
		metaProperties.setOnFinish(onFinish);
	}

	/**
	 * 显示格式
	 * @return 显示格式
	 */
	public String getDateFormat() {
		return metaProperties.getFormat();
	}

	/**
	 * 设置显示格式
	 * @param onFinish 显示格式
	 */
	public void setDateFormat(String format) {
		metaProperties.setFormat(format);
	}

}
