package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.EditorImeOptions;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;

/**
 * 文本编辑框配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */

public class MetaTextEditor extends MetaComponent {

	/** 大小写类型——无限制 */
	public static final int CASETYPE_NONE = 0;
	/** 大小写类型——全小写 */
	public static final int CASETYPE_LOWER = 1;
	/** 大小写类型——全大写 */
	public static final int CASETYPE_UPPER = 2;

	/** 属性对象 */
	MetaTextEditorProperties properties;

	public MetaTextEditor() {
		properties = newProperties();
	}

	/**
	 * 获取输入法选项
	 *
	 * @return 输入法选项，取值范围为{@link EditorImeOptions}
	 */
	public Integer getImeOptions() {
		return properties.getImeOptions();
	}

	/**
	 * 设置输入法选项
	 *
	 * @param imeOptions 输入法选项，取值范围为{@link EditorImeOptions}
	 */
	public void setImeOptions(Integer imeOptions) {
		properties.setImeOptions(imeOptions);
	}

	/**
	 * 获取左侧内嵌文本的字体大小
	 *
	 * @return 左侧内嵌文本的字体大小
	 */
	public Integer getEmbedTextSize() {
		return properties.getEmbedTextSize();
	}

	/**
	 * 设置左侧内嵌文本的字体大小
	 *
	 * @param embedTextSize 左侧内嵌文本的字体大小
	 */
	public void setEmbedTextSize(Integer embedTextSize) {
		properties.setEmbedTextSize(embedTextSize);
	}

	/**
	 * 获取左侧内嵌文本的字体颜色
	 *
	 * @return 左侧内嵌文本的字体颜色
	 */
	public String getEmbedTextColor() {
		return properties.getEmbedTextColor();
	}

	/**
	 * 设置左侧内嵌文本的字体颜色
	 *
	 * @param embedTextColor 左侧内嵌文本的字体颜色
	 */
	public void setEmbedTextColor(String embedTextColor) {
		properties.setEmbedTextColor(embedTextColor);
	}

	/**
	 * 设置最大输入字符长度
	 * 
	 * @param length 最大输入字符长度，负数表示无限制
	 */
	public void setMaxLength(Integer length) {
		this.properties.setMaxLength(length);
	}

	/**
	 * 获取最大输入字符长度
	 * 
	 * @return 最大输入字符长度，负数表示无限制
	 */
	public Integer getMaxLength() {
		return this.properties.getMaxLength();
	}

	/**
	 * 设置是否显示字数统计
	 * @param showWordLimit 是否显示字数统计
	 */
	public void setShowWordLimit(Boolean showWordLimit) {
		this.properties.setShowWordLimit(showWordLimit);
	}
	
	/**
	 * 获取是否显示字数统计
	 * @return 是否显示字数统计
	 */
	public Boolean isShowWordLimit() {
		return properties.isShowWordLimit();
	}

	/**
	 * 设置不允许输入的字符集合
	 * 
	 * @param chars 不允许输入的字符集合
	 */
	public void setInvalidChars(String chars) {
		this.properties.setInvalidChars(chars);
	}

	/**
	 * 获取不允许输入的字符集合
	 * 
	 * @return 不允许输入的字符集合
	 */
	public String getInvalidChars() {
		return this.properties.getInvalidChars();
	}

	/**
	 * 设置大小写转换类型
	 * 
	 * @param caseType 大小写转换类型，取值范围为{@link MetaTextEditor#CASETYPE_NONE},
	 *                  {@link MetaTextEditor#CASETYPE_LOWER}和
	 *                  {@link MetaTextEditor#CASETYPE_UPPER}
	 */
	public void setCaseType(Integer caseType) {
		this.properties.setCaseType(caseType);
	}

	/**
	 * 获取大小写转换类型
	 * 
	 * @return 大小写转换类型，取值范围为{@link MetaTextEditor#CASETYPE_NONE},
	 *          {@link MetaTextEditor#CASETYPE_LOWER}和{@link MetaTextEditor#CASETYPE_UPPER}
	 */
	public Integer getCaseType() {
		return this.properties.getCaseType();
	}

	/**
	 * 通过转换类型字符串获取大小写转换类型
	 * 
	 * @param str 字符串
	 * @return 大小写转换类型
	 */
	public static int parseCaseType(String str) {
		int type = -1;
		if( str.equalsIgnoreCase("None") ) {
			type = CASETYPE_NONE;
		} else if (str.equalsIgnoreCase("Lower")) {
			type = CASETYPE_LOWER;
		} else if (str.equalsIgnoreCase("Upper")) {
			type = CASETYPE_UPPER;
		}
		return type;
	}

	/**
	 * 获取大小写转换类型字符串
	 *
	 * @param type 大小写转换类型
	 * @return 大小写转换类型字符串
	 */
	public static String getCaseTypeStr(Integer type) {
		if(type == null)
			return "";
		
		String str = "";
		if( type == CASETYPE_NONE ) {
			str = "None";
		} else if (type == CASETYPE_LOWER) {
			str = "Lower";
		} else if (type == CASETYPE_UPPER) {
			str = "Upper";
		}
		return str;
	}

	/**
	 * 设置文本为空时的提示信息
	 * 
	 * @param promptText 文本为空时的提示信息
	 */
	public void setPromptText(String promptText) {
		this.properties.setPromptText(promptText);
	}

	/**
	 * 获取文本为空时的提示信息
	 * 
	 * @return 文本为空时的提示信息
	 */
	public String getPromptText() {
		return this.properties.getPromptText();
	}
	
	/**
	 * 设置是否禁用软键盘，针对带有输入框的组件
	 * @param disableKeyboard 是否禁用软键盘
	 */
	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.properties.setDisableKeyboard(disableKeyboard);
	}
	
	/**
	 * 获取是否禁用软键盘，针对带有输入框的组件
	 * @return 是否禁用软键盘
	 */
	public Boolean isDisableKeyboard() {
		return properties.isDisableKeyboard();
	}
	
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_TEXTEDITOR;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.TEXTEDITOR;
	}
	
	/**
	 * 设置是否去除首尾多余空格
	 *
	 * @return 是否去除首尾多余空格
	 */
	public Boolean isTrim() {
		return this.properties.isTrim();
	}

	/**
	 * 获取是否去除首尾多余空格
	 *
	 * @param trim 是否去除首尾多余空格
	 */
	public void setTrim(Boolean trim) {
		this.properties.setTrim(trim);;
	}

	/**
	 * 设置光标进入是否默认全选
	 *
	 * @return 光标进入是否默认全选
	 */
	public Boolean isSelectOnFocus() {
		return this.properties.isSelectOnFocus();
	}

	/**
	 * 获取光标进入是否默认全选
	 *
	 * @param selectOnFocus 光标进入是否默认全选
	 */
	public void setSelectOnFocus(Boolean selectOnFocus) {
		this.properties.setSelectOnFocus(selectOnFocus);;
	}
	
	/**
	 * 移动端特有属性-光标进入是否默认全选
	 * @return
	 */
	public Boolean isMobileSelectOnFocus() {
		return this.properties.isMobileSelectOnFocus();
	}

	/**
	 * 移动端特有属性-光标进入是否默认全选
	 * @param mobileSelectOnFocus
	 */
	public void setMobileSelectOnFocus(Boolean mobileSelectOnFocus) {
		this.properties.setMobileSelectOnFocus(mobileSelectOnFocus);
	}
	
	/**
	 * 设置掩码
	 *
	 * @return 掩码
	 */
	public String getMask() {
		return this.properties.getMask();
	}

	/**
	 * 获取掩码
	 *
	 * @param mask 掩码
	 */
	public void setMask(String mask) {
		this.properties.setMask(mask);;
	}

	/**
	 * 设置右侧图标相对路径
	 *
	 * @return 右侧图标相对路径
	 */
	public String getIcon() {
		return this.properties.getIcon();
	}

	/**
	 * 获取右侧图标相对路径
	 *
	 * @param icon 右侧图标相对路径
	 */
	public void setIcon(String icon) {
		this.properties.setIcon(icon);;
	}
	
	/**
	 * 设置左侧图标相对路径
	 *
	 * @param preIcon 左侧图标相对路径
	 */
	public void setPreIcon(String preIcon) {
		this.properties.setPreIcon(preIcon);
	}
	
	/**
	 * 取得左侧图标相对路径
	 *
	 * @return 左侧图标相对路径
	 */
	public String getPreIcon() {
		return this.properties.getPreIcon();
	}

	/**
	 * 设置左侧内嵌文本
	 *
	 * @return 左侧内嵌文本
	 */
	public String getEmbedText() {
		return this.properties.getEmbedText();
	}

	/**
	 * 获取左侧内嵌文本
	 *
	 * @param embedText 文本
	 */
	public void setEmbedText(String embedText) {
		this.properties.setEmbedText(embedText);
	}

	/**
	 * 获取焦点获取事件
	 *
	 * @return 焦点获取事件
	 */
	public MetaBaseScript getOnFocus() {
		return this.properties.getOnFocus();
	}

	/**
	 * 设置焦点获取事件
	 *
	 * @param onFocus 焦点获取事件
	 */
	public void setOnFocus(MetaBaseScript onFocus) {
		this.properties.setOnFocus(onFocus);
	}

	@Override
	public MetaTextEditor clone() {
		MetaTextEditor newObject = (MetaTextEditor)super.clone();
		newObject.setProperties(properties == null ? null : properties.clone());
		
		return newObject;
	}

	@Override
	public MetaTextEditor newInstance() {
		return new MetaTextEditor();
	}

	@Override
	public MetaTextEditorProperties getProperties() {
		return properties;
	}

	/**
	 * 设置属性对象
	 *
	 * @param properties 属性对象
	 */
	@Override
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaTextEditorProperties) properties;
	}
	
	/**
	 * 获取回车事件
	 *
	 * @return 回事事件
	 */
	public MetaBaseScript getKeyEnter(){
		return properties.getKeyEnter();
	}
	/**
	 * 取得是否保持焦点
	 *
	 * @return 是否保持焦点
	 */
	public Boolean isHoldFocus() {
		return properties.isHoldFocus();
	}

	/**
	 * 生成新的属性对象
	 *
	 * @return 生成的新属性对象
	 */
	public MetaTextEditorProperties newProperties() {
		return new MetaTextEditorProperties();
	}
	
	/**
	 * 获取前缀或后缀符号
	 * @return
	 */
	public String getSuffix() {
		return properties.getSuffix();
	}
	
	/**
	 * 设置前缀或后缀符号
	 * @param 
	 */
	public void setSuffix(String suffix) {
		this.properties.setSuffix(suffix);
	}
	
	/**
	 * 获取前缀或后缀
	 * @return
	 */
	public String getPrefix() {
		return properties.getPrefix();
	}
	
	/**
	 * 设置前缀或后缀
	 * @param  
	 */
	public void setPrefix(String prefix) {
		this.properties.setPrefix(prefix);
	}

}

