package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSliderProperties;

/**
 * 滑杆组件
 * @author chenzs
 *
 */
public class MetaSlider extends MetaComponent {

	public static final String TAG_NAME = ControlType.STR_SLIDER;
	
	/**
	 * 组件属性对象
	 */
	public MetaSliderProperties properties = new MetaSliderProperties();

	/**
	 * 设置最大的指示值
	 * @param maxPos 最大的指示值
	 */
	public void setMaxPos(Integer maxPos) {
		properties.setMaxPos(maxPos);
	}

	/**
	 * 获取最大的指示值
	 * @return 最大的指示值
	 */
	public Integer getMaxPos() {
		return properties.getMaxPos();
	}

	/**
	 * 设置最小的指示值
	 * @param minPos 最小的指示值
	 */
	public void setMinPos(Integer minPos) {
		properties.setMinPos(minPos);
	}

	/**
	 * 获取最小的指示值
	 * @return 最小的指示值
	 */
	public Integer getMinPos() {
		return properties.getMinPos();
	}

	/**
	 * 获取步进值
	 * @return 步进值
	 */ 
	public Integer getStepValue() {
		return properties.getStepValue();
	}

	/**
	 * 设置步进值
	 * @param stepValue 步进值
	 */
	public void setStepValue(Integer stepValue) {
		properties.setStepValue(stepValue);
	}

	/**
	 * 获取默认滑杆条颜色
	 * @return 默认滑杆条颜色
	 */
	public String getBarColor() {
		return properties.getBarColor();
	}

	/**
	 * 设置默认滑杆条颜色
	 * @param barColor 默认滑杆条颜色
	 */
	public void setBarColor(String barColor) {
		this.properties.setBarColor(barColor);
	}

	/**
	 * 获取进度颜色
	 * @return 进度颜色
	 */
	public String getProgressColor() {
		return properties.getProgressColor();
	}

	/**
	 * 设置进度颜色
	 * @param progressColor 进度颜色
	 */
	public void setProgressColor(String progressColor) {
		this.properties.setProgressColor(progressColor);
	}
	
	/**
	 * 设置属性对象
	 * @param properties 属性对象
	 */
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaSliderProperties) properties;
	}
	
	/** 
	 * 获取是否允许多选
	 * 
	 * @return isAllowMultiSelection 是否允许多选
	 */
	public Boolean isAllowMultiSelection(){
		return properties.isAllowMultiSelection();
	}
	
	/**
	 * 设置是否允许多选
	 * 
	 * @param isAllowMultiSelection 是否允许多选
	 */
	public void setAllowMultiSelection(Boolean isAllowMultiSelection) {
		this.properties.setAllowMultiSelection(isAllowMultiSelection);
	}

	@Override
	public int getControlType() {
		return ControlType.SLIDER;
	}

	@Override
	public MetaSliderProperties getProperties() {
		return properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSlider();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSlider metaSlider = (MetaSlider) super.clone();
		metaSlider.setProperties((MetaSliderProperties) properties.clone());
		return metaSlider;
	}
}
