package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelProperties;

public class MetaPriceLabel extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_PRICELABEL;
	private MetaPriceLabelProperties properties = new MetaPriceLabelProperties();

	/**
	 * 获取前置文本
	 * @return 前置文本
	 */
	public String getPreText() {
		return properties.getPreText();
	}

	/**
	 * 设置前置文本
	 * @param preText 前置文本
	 */
	public void setPreText(String preText) {
		properties.setPreText(preText);
	}

	/**
	 * 获取小数位数
	 * @return 小数位数
	 */
	public Integer getDecimalDigits() {
		return properties.getDecimalDigits();
	}

	/**
	 * 设置小数位数
	 * @param decimalDigits 小数位数
	 */
	public void setDecimalDigits(Integer decimalDigits) {
		properties.setDecimalDigits(decimalDigits);
	}

	/**
	 * 获取是否显示千分位
	 * @return 是否显示千分位
	 */
	public Boolean getShowThousandth() {
		return properties.getShowThousandth();
	}

	/**
	 * 设置是否显示千分位
	 * @param showThousandth 是否显示千分位
	 */
	public void setShowThousandth(Boolean showThousandth) {
		properties.setShowThousandth(showThousandth);
	}
	
	/**
	 * 获取定义格式化部分的项的集合
	 * @return 定义格式化部分的项的集合
	 */
	public MetaPriceLabelItemCollection getItemCollection() {
		return properties.getItemCollection();
	}
	
	/**
	 * 设置定义格式化部分的项的集合
	 * @param itemCollection 定义格式化部分的项的集合
	 */
	public void setItemCollection(MetaPriceLabelItemCollection itemCollection) {
		properties.setItemCollection(itemCollection);
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.PRICELABEL;
	}

	@Override
	public MetaPriceLabelProperties getProperties() {
		return properties;
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaPriceLabelProperties) properties;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPriceLabelProperties();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaPriceLabel newObject = (MetaPriceLabel) super.clone();
		newObject.setProperties((MetaPriceLabelProperties) properties.clone());
		return newObject;
	}
}
