package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.EditorImeOptions;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberInfoEditorProperties;

/**
 * 数值信息输入框组件，比如输入固定电话，格式为021-60190088
 * @author chenzs
 *
 */
public class MetaNumberInfoEditor extends MetaComponent {

	public static final String TAG_NAME = ControlType.STR_NUMBERINFOEDITOR;

	/**
	 * 属性对象
	 */
	private MetaNumberInfoEditorProperties properties = new MetaNumberInfoEditorProperties();

	/**
	 * 获取输入法选项，主要修改软键盘回车键类型
	 *
	 * @return 输入法选项，取值范围为{@link EditorImeOptions}
	 */
	public Integer getImeOptions() {
		return properties.getImeOptions();
	}

	/**
	 * 设置输入法选项，主要修改软键盘回车键类型
	 *
	 * @param imeOptions 输入法选项，取值范围为{@link EditorImeOptions}
	 */
	public void setImeOptions(Integer imeOptions) {
		properties.setImeOptions(imeOptions);
	}

	/**
	 * 获取数值显示格式，其中'%'为占位符。例如属性为"%%-%%-%%%"，控件值为123456789时显示为12-34-567
	 *
	 * @return 数值显示格式
	 */
	public String getEditFormat() {
		return properties.getEditorFormat();
	}

	/**
	 * 设置数值显示格式，其中'%'为占位符。例如属性为"%%-%%-%%%"，控件值为123456789时显示为12-34-567
	 *
	 * @param editFormat 数值显示格式
	 */
	public void setEditFormat(String editFormat) {
		properties.setEditorFormat(editFormat);
	}

	/**
	 * 设置属性对象
	 *
	 * @param properties 属性对象
	 */
	@Override
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaNumberInfoEditorProperties) properties;
	}

	/**
	 * 获取焦点获取事件
	 *
	 * @return 焦点获取事件
	 */
	public MetaBaseScript getOnFocus() {
		return this.properties.getOnFocus();
	}

	/**
	 * 设置焦点获取事件
	 *
	 * @param onFocus 焦点获取事件
	 */
	public void setOnFocus(MetaBaseScript onFocus) {
		this.properties.setOnFocus(onFocus);
	}

	/**
	 * 设置是否禁用软键盘，针对带有输入框的组件
	 * @param disableKeyboard 是否禁用软键盘
	 */
	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.properties.setDisableKeyboard(disableKeyboard);
	}
	
	/**
	 * 获取是否禁用软键盘，针对带有输入框的组件
	 * @return 是否禁用软键盘
	 */
	public Boolean isDisableKeyboard() {
		return properties.isDisableKeyboard();
	}

	@Override
	public int getControlType() {
		return ControlType.NUMBERINFOEDITOR;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNumberInfoEditor();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNumberInfoEditor meta = (MetaNumberInfoEditor) super.clone();
		meta.setProperties((MetaNumberInfoEditorProperties) properties.clone());
		return meta;
	}
}
