package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.EditorImeOptions;
import com.bokesoft.yigo.common.def.FormatStyle;
import com.bokesoft.yigo.common.def.RoundingMode;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;

/**
 * 数值编辑框配置对象，主要输入数值，不可输入其他字符
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaNumberEditor extends MetaComponent {
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_NUMBEREDITOR;

	private MetaNumberEditorProperties properties = new MetaNumberEditorProperties();

	/**
	 * 获取输入法选项，主要修改软键盘回车键类型
	 *
	 * @return 输入法选项，取值范围为{@link EditorImeOptions}
	 */
	public Integer getImeOptions() {
		return properties.getImeOptions();
	}

	/**
	 * 设置输入法选项，主要修改软键盘回车键类型
	 *
	 * @param imeOptions 输入法选项，取值范围为{@link EditorImeOptions}
	 */
	public void setImeOptions(Integer imeOptions) {
		properties.setImeOptions(imeOptions);
	}

	/**
	 * 设置数值精度，当取值为非正数时，为无精度限制
	 *
	 * @param precision 数值精度
	 */
	public void setPrecision(Integer precision) {
		this.properties.setPrecision(precision);
	}

	/**
	 * 获取数值精度，当取值为非正数时，为无精度限制
	 *
	 * @return 数值精度
	 */
	public Integer getPrecision() {
		return this.properties.getPrecision();
	}

	/**
	 * 设置小数位位数，当取值为非正数时，为无位数限制
	 *
	 * @param scale 小数位位数
	 */
	public void setScale(Integer scale) {
		this.properties.setScale(scale);
	}

	/**
	 * 获取小数位位数，当取值为非正数时，为无位数限制
	 *
	 * @return 小数位位数
	 */
	public Integer getScale() {
		return this.properties.getScale();
	}

	/**
	 * 设置是否使用组分割，比如千分位
	 *
	 * @param use 是否使用组分割
	 */
	public void setUseGroupingSeparator(Boolean use) {
		this.properties.setUseGroupingSeparator(use);
	}

	/**
	 * 获取是否使用组分割，比如千分位
	 *
	 * @return 是否使用组分割
	 */
	public Boolean isUseGroupingSeparator() {
		return this.properties.isUseGroupingSeparator();
	}

	/**
	 * 获取是否取整型值
	 *
	 * @return 是否取整型值，为true时所有的数值转换按照整型操作
	 */
	public Boolean integerValue() {
		return this.properties.integerValue();
	}

	/**
	 * 设置内容为空的时候的提示文本
	 *
	 * @param promptText 内容为空的时候的提示文本
	 */
	public void setPromptText(String promptText) {
		this.properties.setPromptText(promptText);
	}
	
	/**
	 * 获取内容为空的时候的提示文本
	 *
	 * @return 内容为空的时候的提示文本
	 */
	public String getPromptText() {
		return this.properties.getPromptText();
	}
	
	/**
	 * 获取是否去除末尾多余的0
	 *
	 * @return 是否去除末尾多余的0
	 */
	public Boolean getStripTrailingZeros() {
		return this.properties.getStripTrailingZeros();
	}

	/**
	 * 设置是否去除末尾多余的0
	 *
	 * @param stripTrailingZeros 是否去除末尾多余的0
	 */
	public void setStripTrailingZeros(Boolean stripTrailingZeros) {
		properties.setStripTrailingZeros(stripTrailingZeros);
	}
	
	/**
	 * 获取光标进入是否全选
	 *
	 * @return 光标进入是否全选
	 */
	public Boolean isSelectOnFocus() {
		return this.properties.isSelectOnFocus();
	}

	/**
	 * 设置光标进入是否全选
	 *
	 * @param selectOnFocus 光标进入是否全选
	 */
	public void setSelectOnFocus(Boolean selectOnFocus) {
		this.properties.setSelectOnFocus(selectOnFocus);;
	}
	
	/**
	 * 移动端特有属性-光标进入是否默认全选
	 * @return
	 */
	public Boolean isMobileSelectOnFocus() {
		return this.properties.isMobileSelectOnFocus();
	}

	/**
	 * 移动端特有属性-光标进入是否默认全选
	 * @param mobileSelectOnFocus
	 */
	public void setMobileSelectOnFocus(Boolean mobileSelectOnFocus) {
		this.properties.setMobileSelectOnFocus(mobileSelectOnFocus);
	}
	
	/**
	 * 设置四舍五入规则
	 *
	 * @param mode 四舍五入规则，取值范围为{@link RoundingMode}
	 */
	public void setRoundingMode(Integer mode){
		this.properties.setRoundingMode(mode);
	}
	
	/**
	 * 获取四舍五入规则
	 *
	 * @return 四舍五入规则，取值范围为{@link RoundingMode}
	 */
	public Integer getRoundingMode(){
		return this.properties.getRoundingMode();
	}
	
	/**
	 * 取得是否显示零值
	 *
	 * @return 是否显示零值
	 */
	public Boolean isShowZero(){
		return this.properties.isShowZero();
	}

	/**
	 * 设置0值字符串，只对表格有效
	 *
	 * @param zeroString 0值字符串
	 */
	public void setZeroString(String zeroString) {
		this.properties.setZeroString(zeroString);
	}

	/**
	 * 获取0值字符串，只对表格有效
	 *
	 * @return 0值字符串
	 */
	public String getZeroString() {
		return this.properties.getZeroString();
	}

	/**
	 * 设置负值前景色，只对表格有效
	 *
	 * @param negtiveForeColor 负值前景色
	 */
	public void setNegtiveForeColor(String negtiveForeColor) {
		this.properties.setNegtiveForeColor(negtiveForeColor);
	}

	/**
	 * 获取负值前景色，只对表格有效
	 *
	 * @return 负值前景色
	 */
	public String getNegtiveForeColor() {
		return this.properties.getNegtiveForeColor();
	}

	/**
	 * 组件显示文本格式化类型
	 *
	 * @return 组件显示文本格式化类型，取值范围为{@link FormatStyle}
	 */
	public Integer getFormatStyle() {
		return properties.getFormatStyle();
	}

	/**
	 * 组件显示文本格式化类型
	 *
	 * @param formatStyle 组件显示文本格式化类型，取值范围为{@link FormatStyle}
	 */
	public void setFormatStyle(Integer formatStyle) {
		properties.setFormatStyle(formatStyle);
	}

	/**
	 * 获取焦点获取事件
	 *
	 * @return 焦点获取事件
	 */
	public MetaBaseScript getOnFocus() {
		return this.properties.getOnFocus();
	}

	/**
	 * 设置焦点获取事件
	 *
	 * @param onFocus 焦点获取事件
	 */
	public void setOnFocus(MetaBaseScript onFocus) {
		this.properties.setOnFocus(onFocus);
	}

	/**
	 * 设置是否禁用软键盘，针对带有输入框的组件
	 * @param disableKeyboard 是否禁用软键盘
	 */
	public void setDisableKeyboard(Boolean disableKeyboard) {
		this.properties.setDisableKeyboard(disableKeyboard);
	}
	
	/**
	 * 获取是否禁用软键盘，针对带有输入框的组件
	 * @return 是否禁用软键盘
	 */
	public Boolean isDisableKeyboard() {
		return properties.isDisableKeyboard();
	}
	
	/**
	 * 获取前缀或后缀符号
	 * @return
	 */
	public String getSuffix() {
		return properties.getSuffix();
	}
	
	/**
	 * 设置前缀或后缀符号
	 * @param aSign 符号
	 */
	public void setSuffix(String suffix) {
		this.properties.setSuffix(suffix);
	}
	
	/**
	 * 获取前缀或后缀
	 * @return
	 */
	public String getPrefix() {
		return properties.getPrefix();
	}
	
	/**
	 * 设置前缀或后缀
	 * @param pSign 
	 */
	public void setPrefix(String prefix) {
		this.properties.setPrefix(prefix);
	}
	
	public String getFormulaText(){
		return properties.getFormulaText();
	}
	
	public void setFormulaText(String formulaText){
		this.properties.setFormulaText(formulaText);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.NUMBEREDITOR;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaNumberEditor newObject = (MetaNumberEditor)super.clone();
		newObject.setProperties((MetaNumberEditorProperties)properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNumberEditor();
	}

	@Override
	public MetaNumberEditorProperties getProperties() {
		return properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaNumberEditorProperties) properties;
	}
}
