package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.common.def.ImageViewMode;
import com.bokesoft.yigo.common.def.UploadProgressType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageProperties;

/**
 * 图片配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaImage extends MetaComponent {

	private MetaImageProperties properties = new MetaImageProperties();
	
	public MetaImage() {
		super();
	}

	/**
	 * 获取显示上传进度指示器的样式
	 *
	 * @return 显示上传进度指示器的样式，取值范围为{@link UploadProgressType}
	 */
	public Integer getUploadProgress() {
		return properties.getUploadProgress();
	}

	/**
	 * 设置显示上传进度指示器的样式，取值范围为{@link UploadProgressType}
	 *
	 * @param uploadProgress 显示上传进度指示器的样式，取值范围为{@link UploadProgressType}
	 */
	public void setUploadProgress(Integer uploadProgress) {
		properties.setUploadProgress(uploadProgress);
	}

	/**
	 * 获取是否显示缩略图
	 *
	 * @return 是否显示缩略图，如果是true，则会先从所给图片路径下的同级目录的temp文件夹中拿同样的
	 *          文件名的图片，例如：图片路径为 UIDemo/1.jpg，缩略图路径则是UIDemo/temp/1.jpg，
	 *          如果找不到缩略图，则直接取原图；如果是false，则取原图。
	 */
	public Boolean isShowThumbnail() {
		return properties.isShowThumbnail();
	}

	/**
	 * 设置是否显示缩略图
	 *
	 * @param showThumbnail 是否显示缩略图，如果是true，则会先从所给图片路径下的同级目录的
	 *                       temp文件夹中拿同样的文件名的图片，例如：图片路径为 UIDemo/1.jpg，
	 *                       缩略图路径则是UIDemo/temp/1.jpg，如果找不到缩略图，则直接取原图；
	 *                       如果是false，则取原图。
	 */
	public void setShowThumbnail(Boolean showThumbnail) {
		properties.setShowThumbnail(showThumbnail);
	}

	/**
	 * 设置图片来源类型
	 *
	 * @param type 图片来源类型，取值范围为{@link ImageSourceType}
	 */
	public void setSourceType(Integer type) {
		this.properties.setSourceType(type);
	}

	/**
	 * 获取图片来源类型
	 *
	 * @return 图片来源类型，取值范围为{@link ImageSourceType}
	 */
	public Integer getSourceType() {
		return this.properties.getSourceType();
	}

	/**
	 * 设置图片相对路径，仅{@link #getSourceType()}为{@link ImageSourceType#RESOURCE}时生效
	 *
	 * @param image 图片相对路径
	 */
	public void setImage(String image) {
		this.properties.setImage(image);
	}

	/**
	 * 获取图片相对路径，仅{@link #getSourceType()}为{@link ImageSourceType#RESOURCE}时生效
	 *
	 * @return 图片相对路径
	 */
	public String getImage() {
		return this.properties.getImage();
	}

	/**
	 * 设置点击事件，仅{@link #getViewMode()}为{@link ImageViewMode#SELF}时有效
	 *
	 * @param onClick 点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.properties.setOnClick(onClick);
	}

	/**
	 * 获取点击事件，仅{@link #getViewMode()}为{@link ImageViewMode#SELF}时有效
	 *
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.properties.getOnClick();
	}

//	/**
//	 * 设置是否拉伸
//	 *
//	 * @param stretch 是否拉伸
//	 */
//	public void setStrectch(boolean stretch) {
//		this.properties.setStretch(stretch);
//	}
//
//	/**
//	 * 获取是否拉伸
//	 *
//	 * @return 是否拉伸
//	 */
//	public boolean isStretch() {
//		return this.properties.isStretch();
//	}

	/**
	 * 获取上传文件大小的最大值，单位KB
	 *
	 * @return 上传文件大小的最大值
	 */
	public Integer getMaxSize() {
		return this.properties.getMaxSize();
	}

	/**
	 * 设置上传文件大小的最大值，单位KB
	 *
	 * @param maxSize 上传文件大小的最大值
	 */
	public void setMaxSize(Integer maxSize) {
		this.properties.setMaxSize(maxSize);
	}

	/**
	 * 获取拉伸缩放类型
	 *
	 * @return 拉伸缩放类型
	 */
	public Integer getImageScaleType() {
		return properties.getImageScaleType();
	}

	/**
	 * 设置拉伸缩放类型
	 *
	 * @param imageScaleType 拉伸缩放类型
	 */
	public void setImageScaleType(Integer imageScaleType) {
		this.properties.setImageScaleType(imageScaleType);
	}

	/**
	 * 获取没有值时的提示图片，仅{@link #getSourceType()}不为{@link ImageSourceType#RESOURCE}时生效
	 *
	 * @return 没有值时的提示图片
	 */
	public String getPromptImage() {
		return this.properties.getPromptImage();
	}

	/**
	 * 设置没有值时的提示图片，仅{@link #getSourceType()}不为{@link ImageSourceType#RESOURCE}时生效
	 *
	 * @param promptImage 没有值时的提示图片
	 */
	public void setPromptImage(String promptImage) {
		this.properties.setPromptImage(promptImage);
	}

	/**
	 * 获取图片圆角半径
	 *
	 * @return 图片圆角半径
	 */
	public Integer getRadius() {
		return this.properties.getRadius();
	}

	/**
	 * 设置图片圆角半径
	 *
	 * @param radius 图片圆角半径
	 */
	public void setRadius(Integer radius) {
		this.properties.setRadius(radius);
	}

	/**
	 * 获取图片上传文件名，上传时如果该值不为空，则上传使用该文件名
	 *
	 * @return 图片上传文件名
	 */
	public String getFileName() {
		return this.properties.getFileName();
	}

	/**
	 * 设置图片上传文件名，上传时如果该值不为空，则上传使用该文件名
	 *
	 * @param fileName 图片上传文件名
	 */
	public void setFileName(String fileName) {
		this.properties.setFileName(fileName);
	}

	/**
	 * 获取图片查看模式
	 *
	 * @return 图片查看模式，取值范围为{@link ImageViewMode}
	 */
	public Integer getViewMode() {
		return this.properties.getViewMode();
	}

	/**
	 * 设置图片查看模式
	 *
	 * @param viewMode 图片查看模式，取值范围为{@link ImageViewMode}
	 */
	public void setViewMode(Integer viewMode) {
		this.properties.setViewMode(viewMode);
	}

	/**
	 * 获取图片是否允许查看操作，比如缩放、旋转等等
	 *
	 * @return 是否允许查看操作
	 */
	public Boolean isViewOpt() {
		return this.properties.isViewOpt();
	}

	/**
	 * 设置图片是否允许查看操作，比如缩放、旋转等等
	 *
	 * @param viewOpt 是否允许查看操作
	 */
	public void setViewOpt(Boolean viewOpt) {
		this.properties.setViewOpt(viewOpt);
	}

	/**
	 * 获取图片形状截取模板，一般用于头像
	 *
	 * @return 模板来源
	 */
	public String getMaskImage() {
		return this.properties.getMaskImage();
	}

	/**
	 * 设置图片形状截取模板，一般用于头像
	 *
	 * @param maskImage 模板来源
	 */
	public void setMaskImage(String maskImage) {
		this.properties.setMaskImage(maskImage);
	}

	/**
	 * 获取拍照完或者选取相册完是否剪切
	 *
	 * @return 拍照完或者选取相册完是否剪切
	 */
	public Boolean isImageCut() {
		return this.properties.isImageCut();
	}

	/**
	 * 设置拍照完或者选取相册完是否剪切
	 *
	 * @param imageCut 拍照完或者选取相册完是否剪切
	 */
	public void setImageCut(Boolean imageCut) {
		this.properties.setImageCut(imageCut);
	}

	/**
	 * 获取图片加载到内存中大小的最大值，单位KB
	 *
	 * @return 图片加载到内存中大小的最大值
	 */
	public Integer getMaxShowSize() {
		return properties.getMaxShowSize();
	}

	/**
	 * 设置图片加载到内存中大小的最大值，单位KB
	 *
	 * @param maxShowSize 图片加载到内存中大小的最大值
	 */
	public void setMaxShowSize(Integer maxShowSize) {
		properties.setMaxShowSize(maxShowSize);
	}
	
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_IMAGE;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.IMAGE;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaImage newObject = (MetaImage)super.clone();
		newObject.setProperties((MetaImageProperties)properties.clone());

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaImage();
	}

	@Override
	public MetaImageProperties getProperties() {
		return properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaImageProperties) properties;
	}
}
