package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;

/**
 * 字典配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaCompDict extends MetaDict {
	//private MetaDictProperties properties = new MetaDictProperties();

	
	public MetaCompDict(){
		super();
		properties.setCompDict(true);
	}
	
	//public void setFilterDependency(DependencyID filterDependency){
	//	this.properties.setFilterDependency(filterDependency);
	//}
	//
	//public DependencyID getFilterDependency(){
	//	return this.properties.getFilterDependency();
	//}
	

	/**
	 * 设置字典关联对象的标识
	 * 
	 * @param key
	 *            关联对象标识
	 */
	public void setItemKey(String key) {
		this.properties.setItemKey(key);
	}

	/**
	 * 获取字典关联对象的标识
	 * 
	 * @return 关联对象标识
	 */
	public String getItemKey() {
		return this.properties.getItemKey();
	}

	/**
	 * 设置是否允许多选
	 * 
	 * @param allow
	 *            是否允许多选
	 */
	public void setAllowMultiSelection(Boolean allow) {
		this.properties.setAllowMultiSelection(allow);
	}

	/**
	 * 获取是否允许多选
	 * 
	 * @return 是否允许多选
	 */
	@Override
	public Boolean isAllowMultiSelection() {
		return this.properties.isAllowMultiSelection();
	}

	/**
	 * 设置是否为父子节点联动
	 * 
	 * @param independent
	 *            是否为父子节点联动
	 */
	public void setIndependent(Boolean independent) {
		this.properties.setIndependent(independent);
	}

	/**
	 * 获取是否为父子节点联动
	 * 
	 * @return 是否为父子节点联动
	 */
	@Override
	public Boolean isIndependent() {
		return this.properties.isIndependent();
	}
	
	public MetaItemFilterCollection getFilters() {
		return properties.getFilters();
	}

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_COMPDICT;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.COMPDICT;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaCompDict newObject = (MetaCompDict)super.clone();
		newObject.setProperties((MetaDictProperties)properties.clone());
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCompDict();
	}

	@Override
	public MetaDictProperties getProperties() {
		return properties;
	}
	
	public void setProperties(MetaDictProperties properties) {
		this.properties = properties;
	}
}
