package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaCalendar extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_CALENDAR;
	public static final long DEFAULT_MIN_DATE = 31536000000L;
	public static final long DEFAULT_MAX_DATE = 2713824000000L;

	/** 最小日期 默认是1971-1-1 */
	private Long minDate = DEFAULT_MIN_DATE;

	/** 最大日期 默认是2055-12-31 */
	private Long maxDate = DEFAULT_MAX_DATE;

	/** 是否允许多选 */
	private Boolean isAllowMultiSelection = false;

	/**
	 * 获取最大日期
	 *
	 * @return maxDate
	 */
	public Long getMaxDate() {
		return maxDate;
	}

	/**
	 * 设置最大日期
	 *
	 * @param maxDate 最大日期
	 */
	public void setMaxDate(Long maxDate) {
		this.maxDate = maxDate;
	}

	/**
	 * 获取最小日期
	 *
	 * @return minDate
	 */
	public Long getMinDate() {
		return minDate;
	}

	/**
	 * 设置最小日期
	 *
	 * @param minDate 最小日期
	 */
	public void setMinDate(Long minDate) {
		this.minDate = minDate;
	}

	/**
	 * 获取是否允许多选
	 *
	 * @return isAllowMultiSelection 是否允许多选
	 */
	public Boolean isAllowMultiSelection() {
		return isAllowMultiSelection;
	}

	/**
	 * 设置是否允许多选
	 *
	 * @param allowMultiSelection 是否允许多选
	 */
	public void setAllowMultiSelection(Boolean allowMultiSelection) {
		isAllowMultiSelection = allowMultiSelection;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.CALENDAR;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public MetaCalendar newInstance() {
		return new MetaCalendar();
	}

	@Override
	public MetaCalendar clone() {
		MetaCalendar clone = (MetaCalendar) super.clone();
		clone.setMaxDate(maxDate);
		clone.setMinDate(minDate);
		clone.setAllowMultiSelection(isAllowMultiSelection);
		return clone;
	}
}
