package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;

public class MetaNavigationBar extends GenericKeyCollection<MetaNavigationBarItem> {

	public static final String TAG_NAME = "NavigationBar"; 
	
	/** Title来源，其值为None, Caption，AbbrCaption或具体字符串 */
	private String title = null;
	/** 左按钮 */
	private MetaNavigationBarLeftButton leftButton = null;
	/** 右按钮 */
	private MetaNavigationBarRightButton rightButton = null;
	/** 背景色 */
	private String backColor = "";
	/** 前景色 ：导航条默认的Title的文本颜色。*/
	private String foreColor = "";
	/** 是否有左回退按钮，其值为""、"true"、"false"。默认为""。Android使用，IOS不处理 */
	private String hasLeftButton = "";
	/** 是否有右边操作引导按钮，其值为""、"true"、"false"。默认为""。Android使用，IOS不处理 */
	private String hasRightButton = "";
	/** 高度，用于设置底部阴影效果*/
	private Integer elevation = null;
	/** 背景图 */
	private String backImage = "";

	/**
	 * 设置标题
	 * @param title 标题
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * 取得标题
	 * @return 标题
	 */
	public String getTitle() {
		return title;
	}
	
	/**
	 * 设置左按钮
	 * @param leftButton 左按钮
	 */
	public void setLeftButton(MetaNavigationBarLeftButton leftButton) {
		this.leftButton = leftButton;
	}
	
	/**
	 * 取得左按钮
	 * @return 左按钮
	 */
	public MetaNavigationBarLeftButton getLeftButton() {
		return this.leftButton;
	}
	
	/**
	 * 设置右按钮
	 * @param rightButton 右按钮
	 */
	public void setRightButton(MetaNavigationBarRightButton rightButton) {
		this.rightButton = rightButton;
	}
	
	/**
	 * 取得右按钮
	 * @return 右按钮
	 */
	public MetaNavigationBarRightButton getRightButton() {
		return this.rightButton;
	}
	
	/**
	 * 取得背景色
	 * @return 背景色
	 */
	public String getBackColor() {
		return backColor;
	}

	/**
	 * 设置背景色
	 * @param  backColor 背景色
	 */
	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}

	
	/**
	 * 取得前景色
	 * @return 前景色
	 */
	public String getForeColor() {
		return foreColor;
	}

	
	/**
	 * 设置前景色
	 * @param  foreColor 前景色
	 */
	public void setForeColor(String foreColor) {
		this.foreColor = foreColor;
	}

	
	/**
	 * 是否有左回退按钮
	 * @return 是否有左回退按钮
	 */
	public String getHasLeftButton() {
		return hasLeftButton;
	}

	/**
	 * 设置是否有左回退按钮
	 * @param  hasLeftButton 是否有左回退按钮
	 */
	public void setHasLeftButton(String hasLeftButton) {
		this.hasLeftButton = hasLeftButton;
	}

	/**
	 * 是否有右回退按钮
	 * @return 是否有右回退按钮
	 */
	public String getHasRightButton() {
		return this.hasRightButton;
	}

	/**
	 * 设置是否有右回退按钮
	 * @param  hasRightButton 是否有右回退按钮
	 */
	public void setHasRightButton(String hasRightButton) {
		this.hasRightButton = hasRightButton;
	}
	
	/**
	 * 取得高度，用于设置阴影效果 
	 * 
	 * @return 高度
	 */
	public Integer getElevation() {
		return elevation;
	}
	
	/**
	 * 设置高度，用于设置阴影效果
	 * 
	 * @param elevation 高度
	 */
	public void setElevation(Integer elevation) {
		this.elevation = elevation;
	}
	
	/**
	 * 获取背景图
	 * @return 背景图
	 */
	public String getBackImage() {
		return backImage;
	}
	
	/**
	 * 设置背景图
	 * @param backImage 背景图
	 */
	public void setBackImage(String backImage) {
		this.backImage = backImage;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { 
				rightButton, 
				leftButton, 
				}); 
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if ( tagName.equals(MetaConstants.NAVIGATION_BARITEM) ) {
			child = new MetaNavigationBarItem();
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((MetaNavigationBarItem) child);
		} else if ( tagName.equals(MetaNavigationBarLeftButton.TAG_NAME) ) {
			this.leftButton = new MetaNavigationBarLeftButton();
			child = this.leftButton;
		} else if ( tagName.equals(MetaNavigationBarRightButton.TAG_NAME) ) {
			this.rightButton = new MetaNavigationBarRightButton();
			child = this.rightButton;
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNavigationBar newObj = (MetaNavigationBar) super.clone();
		newObj.setTitle(title);
		newObj.setLeftButton(leftButton == null ? null : (MetaNavigationBarLeftButton)leftButton.clone());
		newObj.setRightButton(rightButton == null ? null : (MetaNavigationBarRightButton)rightButton.clone());
		newObj.setBackColor(backColor);
		newObj.setForeColor(foreColor);
		newObj.setHasLeftButton(hasLeftButton);
		newObj.setHasRightButton(hasRightButton);
		newObj.setElevation(elevation);
		newObj.setBackImage(backImage);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNavigationBar();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		for (MetaNavigationBarItem item : this) {
			item.doPostProcess(flag, callback);
		}
	}

	/**
	 * 合并MobileDef中相关的属性
	 */
	public void mergePropertiesWithMobileDef(MetaNavigationBar projectNavigationBar, MetaNavigationBar solutionNavigationBar) {
		if (title == null || title.isEmpty()) {
			if (projectNavigationBar != null) {
				title = projectNavigationBar.getTitle();
			}
			if (title == null || title.isEmpty()) {
				if (solutionNavigationBar != null) {
					title = solutionNavigationBar.getTitle();
				}
			}
		}

		if (leftButton == null) {
			if (projectNavigationBar != null) {
				leftButton = projectNavigationBar.getLeftButton();
			}
			if (leftButton == null) {
				if (solutionNavigationBar != null) {
					leftButton = solutionNavigationBar.getLeftButton();
				}
			}
		}
		if (leftButton != null) {
			String icon = leftButton.getIcon();
			if (icon == null || icon.isEmpty()) {
				if (projectNavigationBar != null && projectNavigationBar.getLeftButton() != null) {
					icon = projectNavigationBar.getLeftButton().getIcon();
				}
				if (icon == null || icon.isEmpty()) {
					if (solutionNavigationBar != null && solutionNavigationBar.getLeftButton() != null) {
						icon = solutionNavigationBar.getLeftButton().getIcon();
					}
				}
				leftButton.setIcon(icon);
			} 
		}

		if (rightButton == null) {
			if (projectNavigationBar != null) {
				rightButton = projectNavigationBar.getRightButton();
			}
			if (rightButton == null) {
				if (solutionNavigationBar != null) {
					rightButton = solutionNavigationBar.getRightButton();
				}
			}
		}
		if (rightButton != null) {
			String icon = rightButton.getIcon();
			if (icon == null || icon.isEmpty()) {
				if (projectNavigationBar != null && projectNavigationBar.getRightButton() != null) {
					icon = projectNavigationBar.getRightButton().getIcon();
				}
				if (icon == null || icon.isEmpty()) {
					if (solutionNavigationBar != null && solutionNavigationBar.getRightButton() != null) {
						icon = solutionNavigationBar.getRightButton().getIcon();
					}
				}
				rightButton.setIcon(icon);
			} 
		}
		
		if (backColor == null || backColor.isEmpty()) {
			if (projectNavigationBar != null) {
				backColor = projectNavigationBar.getBackColor();
			}
			if (backColor == null || backColor.isEmpty()) {
				if (solutionNavigationBar != null) {
					backColor = solutionNavigationBar.getBackColor();
				}
			}
		}
		if (foreColor == null || foreColor.isEmpty()) {
			if (projectNavigationBar != null) {
				foreColor = projectNavigationBar.getForeColor();
			}
			if (foreColor == null || foreColor.isEmpty()) {
				if (solutionNavigationBar != null) {
					foreColor = solutionNavigationBar.getForeColor();
				}
			}
		}
		if (hasLeftButton == null || hasLeftButton.isEmpty()) {
			if (projectNavigationBar != null) {
				hasLeftButton = projectNavigationBar.getHasLeftButton();
			}
			if (hasLeftButton == null || hasLeftButton.isEmpty()) {
				if (solutionNavigationBar != null) {
					hasLeftButton = solutionNavigationBar.getHasLeftButton();
				}
			}
		}
		if (hasRightButton == null || hasRightButton.isEmpty()) {
			if (projectNavigationBar != null) {
				hasRightButton = projectNavigationBar.getHasRightButton();
			}
			if (hasRightButton == null || hasRightButton.isEmpty()) {
				if (solutionNavigationBar != null) {
					hasRightButton = solutionNavigationBar.getHasRightButton();
				}
			}
		}
		if (elevation == null || elevation == -1) {
			if (projectNavigationBar != null) {
				elevation = projectNavigationBar.getElevation();
			}
			if (elevation == null || elevation == -1) {
				if (solutionNavigationBar != null) {
					elevation = solutionNavigationBar.getElevation();
				}
			}
		}
		if (backImage == null || backImage.isEmpty()) {
			if (projectNavigationBar != null) {
				backImage = projectNavigationBar.getBackImage();
			}
			if (backImage == null || backImage.isEmpty()) {
				if (solutionNavigationBar != null) {
					backImage = solutionNavigationBar.getBackImage();
				}
			}
		}
	}
}
