package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;

public class MetaFormProfile extends KeyPairMetaObject {
	/** 标题*/
	private String key = "";
	/** 名称*/
	private String caption = "";
	/** 资源所在目录 */
	private String path = null;
	/** 资源全路径 */
	private String resource = null;
	/** 表单类型*/
	private int formType = -1;
	/** 继承的父表单*/
	private String extend = null;
	/** 合并至父表单*/
	private Boolean mergeToSource = false;
	/** 持有的配置对象*/
	private MetaForm form = null;
	/** 所在工程引用*/
	private transient IMetaProject project = null;
	/** 支持的平台列表 */
	private Integer platform;
	/** 表单别名 */
	private String aliasKey;

	/** 源表单标识 */
	private String sourceForm;
	/** 设计器专用的属性，此属性不持久化XML **/
	private int runType = AppRunType.App;
	public MetaFormProfile() {
		super();
	}

	public static final String TAG_NAME = "Form";

	public int getRunType() {
		return runType;
	}

	public void setRunType(int runType) {
		this.runType = runType;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
													String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getCaption() {
		return caption;
	}

	/**
	 * 设置资源所在目录
	 * @param path 目录
	 */
	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * 取得资源所在目录
	 * @return 目录
	 */
	public String getPath() {
		return this.path;
	}

	/**
	 * 设置资源全路径
	 * @param resource 资源全路径
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}

	/**
	 * 取得资源全路径
	 * @return 资源全路径
	 */
	public String getResource() {
		return this.resource;
	}

	public void setFormType(int formType) {
		this.formType = formType;
	}

	public int getFormType() {
		return this.formType;
	}

	public String getExtend() {
		return extend;
	}

	public void setExtend(String extend) {
		this.extend = extend;
	}

	public Boolean getMergeToSource() {
		return mergeToSource;
	}

	public void setMergeToSource(Boolean mergeToSource) {
		this.mergeToSource = mergeToSource;
	}

	public void setForm(MetaForm form) {
		this.form = form;
	}

	public MetaForm getForm() {
		return form;
	}

	public void setProject(IMetaProject project) {
		this.project = project;
	}

	public IMetaProject getProject() {
		return project;
	}

	public Integer getPlatform() {
		if(platform > 0){
			return platform;
		}else{
			return project.getPlatform();
		}
	}

	public void setPlatform(Integer platform) {
		this.platform = platform;
	}

	public String getAliasKey() {
		return aliasKey;
	}

	public void setAliasKey(String aliasKey) {
		this.aliasKey = aliasKey;
	}

	public String getSourceForm() {
		return sourceForm;
	}

	public void setSourceForm(String sourceForm) {
		this.sourceForm = sourceForm;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFormProfile newObject = new MetaFormProfile();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setResource(resource);
		newObject.setFormType(formType);
		newObject.setForm(form);
		newObject.setProject(project);
		newObject.setExtend(extend);
		newObject.setMergeToSource(mergeToSource);
		newObject.setPlatform(platform);
		newObject.setAliasKey(aliasKey);
		newObject.setSourceForm(sourceForm);
		return newObject;
	}
	@Override
	public AbstractMetaObject depthClone() {
		MetaFormProfile metaFormProfile = (MetaFormProfile) super.depthClone();
		metaFormProfile.setProject(this.project);
		return metaFormProfile;
	}
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFormProfile();
	}
}
