package com.bokesoft.yigo.meta.flatcanvas.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observer;

import org.w3c.dom.Element;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.flatcanvas.common.AttributeItem;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.struct.FCAttrNames;

/**
 *  平面图中的文本对象
 *  
 * @author chenbinbin
 *
 */
public class MetaFCText extends AbstractMetaFCNode {
	
	public static final String TAG_NAME = "Text";
	
	private MetaFCFont font = null;

	private static final List<String> ATTRS_TEXT = Arrays.asList(
			FCAttrNames.ATTR_x, FCAttrNames.ATTR_y, FCAttrNames.ATTR_text,
			FCAttrNames.ATTR_fill);
	
	public MetaFCText() {
		font = new MetaFCFont();
	}
	
	public MetaFCText(int x, int y) {
		setX(x);
		setY(y);
		font = new MetaFCFont();
	}
	
	/**
	 * 获取文字颜色
	 * 
	 * @return 文字颜色
	 */
	public String getFill() {
		return StringUtil.isBlankOrNull(this.get(FCAttrNames.ATTR_fill)) ? "#000000" : this.get(FCAttrNames.ATTR_fill);
	}
	
	/**
	 * 获取字体名称
	 * 
	 * @return 字体名称
	 */
	public String getFontName() {
		return font.getName();
	}
	
	/**
	 * 获取字体大小
	 * 
	 * @return 字体大小
	 */
	public int getFontSize() {
		return font.getSize();
	}
	
	/**
	 * 获取字体是否斜体
	 * 
	 * @return 字体是否斜体
	 */
	public String getFontStyle() {
		return font.getStyle();
	}
	
	/**
	 * 获取字体是否加粗
	 * 
	 * @return 字体是否加粗
	 */
	public String getFontWeight() {
		return font.get(FCAttrNames.ATTR_fontweight);
	}
	
	/**
	 * 获取文本对象内容
	 * 
	 * @return 文本对象内容
	 */
	public String getText() {
		return this.get(FCAttrNames.ATTR_text);
	}
	
	/**
	 * 设置文本配置对象内容， 此处可以设置对关联表字段的引用,例: "{表格列标志}"
	 * 
	 * @param text 文本对象内容
	 */
	public void setText(String text) {
		set(FCAttrNames.ATTR_text, text);
	}
	
	/**
	 * 添加属性变化监听
	 * 
	 * @param observer 变化监听
	 */
	public void addAttrObserver(Observer observer) {
		super.addAttrObserver(observer);
		font.addAttrObserver(observer);
	}
	
	@Override
	protected void loadChild(Element elem) {
		if (elem.getElementsByTagName(MetaFCFont.TAG_NAME) != null) {
			Element child = (Element) elem.getElementsByTagName(MetaFCFont.TAG_NAME).item(0);
			font.loadFromElement(child);
		}
	}

	@Override
	public List<String> getPropItemKeys() {
		return ATTRS_TEXT;
	}
	
	@Override
	public List<AttributeItem> getPropItems() {
		List<AttributeItem> items = new ArrayList<AttributeItem>();
		List<AttributeItem> sectionPropItems = super.getPropItems();
		for (AttributeItem item: sectionPropItems) {
			items.add(item);
		}
		
		List<AttributeItem> fontPropItems = font.getPropItems();
		for (AttributeItem item: fontPropItems) {
			items.add(item);
		}
		return items;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	protected boolean isCollection() {
		return false;
	}

	@Override
	protected boolean saveChild(IContentHandler saveHandler, INode node) {
		return font.saveTo(saveHandler, node);
	}
}
