package com.bokesoft.yigo.meta.flatcanvas.node;

import java.util.Arrays;
import java.util.List;

import org.w3c.dom.Element;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.struct.FCAttrNames;

public class MetaFCFont extends AbstractMetaFCNode {
	
	public static final String TAG_NAME = "Font";
	
	private static final List<String> ATTRS_FONT = Arrays.asList(
			FCAttrNames.ATTR_fontname, FCAttrNames.ATTR_fontsize, FCAttrNames.ATTR_fontstyle,
			FCAttrNames.ATTR_fontweight);
	
	
	
	/**
	 * 获取字体名称
	 * 
	 * @return 字体名称
	 */
	public String getName() {
		return get(FCAttrNames.ATTR_fontname);
	}
	
	/**
	 * 获取字体大小
	 * 
	 * @return 字体大小
	 */
	public Integer getSize() {
		return StringUtil.isBlankOrNull(get(FCAttrNames.ATTR_fontsize))? -1 :TypeConvertor.toInteger(get(FCAttrNames.ATTR_fontsize));
	}
	
	/**
	 * 获取字体样式,是否斜体
	 * 
	 * @return 字体字体样式
	 */
	public String getStyle() {
		return get(FCAttrNames.ATTR_fontstyle);
	}
	
	/**
	 * 获取字体粗细
	 * 
	 * @return 字体粗细
	 */
	public Integer getWeight() {
		return TypeConvertor.toInteger(get(FCAttrNames.ATTR_fontweight));
	}
	
	
	@Override
	protected void loadChild(Element elem) {
	
	}

	@Override
	public List<String> getPropItemKeys() {
		return ATTRS_FONT;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	protected boolean isCollection() {
		return false;
	}

	@Override
	protected boolean saveChild(IContentHandler saveHandler, INode node) {
		return false;
	}

}
