//package com.bokesoft.yigo.meta.factory;
//
//import java.io.ByteArrayOutputStream;
//import java.io.InputStream;
//import java.net.HttpURLConnection;
//import java.net.URI;
//import java.net.URL;
//import java.net.URLEncoder;
//import java.nio.charset.StandardCharsets;
//import java.util.List;
//
//import org.json.JSONArray;
//import org.json.JSONObject;
//
//import com.bokesoft.yigo.meta.base.IMetaResolver;
//
//public class RemoteMetaResourceResolver implements IMetaResolver {
//	private String parentPath = null;
//	private String prefix = null;
//	
//	public RemoteMetaResourceResolver(String parentPath, String prefix) {
//		this.parentPath = parentPath;
//		this.prefix = prefix;
//	}
//
//	@Override
//	public boolean isListAbsolutePath() {
//		return false;
//	}
//
//	@Override
//	public InputStream read(String resource, int type) throws Exception {
//		InputStream is = null;
//		HttpURLConnection conn = null;
//		try {
//			URL url = new URL(this.getPath(resource));
//			conn = (HttpURLConnection) url.openConnection();
//			conn.setRequestMethod("GET");
//			conn.setDoInput(true);
//			conn.connect();
//			if( conn.getResponseCode() == HttpURLConnection.HTTP_OK ) {
//				is = conn.getInputStream();
//			}
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		return is;
//	}
//
//	@Override
//	public URI getURI(String resource, int type) throws Exception {
//		return new URL(this.getPath(resource)).toURI();
//	}
//
//	@Override
//	public boolean write(String resource, byte[] data) throws Exception {
//		return false;
//	}
//
//	@Override
//	public String getPath(String resource) throws Exception {
//		String fileName = null;
//		if( this.prefix != null && !this.prefix.isEmpty() ) {
//			fileName = this.prefix + this.getSeparator() + resource;
//		} else {
//			fileName = resource;
//		}	
//		return this.parentPath + "?fileName=" + URLEncoder.encode(fileName,"UTF-8");
//	}
//
//	@Override
//	public int listResource(String resource, String flag, List<String> resources, List<String> names,
//			List<Boolean> flags) throws Exception {
//		InputStream is = null;
//		HttpURLConnection conn = null;
//		ByteArrayOutputStream baos = new ByteArrayOutputStream();
//		try {
//			URL url = new URL(this.getPath(resource));
//			conn = (HttpURLConnection) url.openConnection();
//			conn.setRequestMethod("GET");
//			conn.setDoInput(true);
//			conn.connect();
//			if( conn.getResponseCode() == HttpURLConnection.HTTP_OK ) {
//				is = conn.getInputStream();
//				byte[] buffer = new byte[256];
//				int len = 0;
//				while( (len = is.read(buffer)) > 0 ) {
//					baos.write(buffer,0,len);
//				}
//				String s = new String(baos.toByteArray(), StandardCharsets.UTF_8);
//				JSONArray arr = new JSONArray(s);
//				for( int i = 0;i < arr.length();i++ ) {
//					JSONObject o = arr.optJSONObject(i);
//					String name = o.optString("name");
//					resources.add(name);
//					names.add(name);
//					flags.add(o.optBoolean("isDirectory"));
//				}
//			}
//		} catch (Exception e) {
//			e.printStackTrace();
//		} finally {
//			if( is != null ) {
//				is.close();
//			}
//			if( baos != null ) {
//				baos.close();
//			}
//		}
//		return resources.size();
//	}
//
//	@Override
//	public char getSeparator() {
//		return '/';
//	}
//
//}
