package com.bokesoft.yigo.meta.factory;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.IConfigResolver;

public class RemoteConfigResolver implements IConfigResolver {

	@Override
	public InputStream read(String parentPath, String prefix, String resource, int type) throws Exception {
		InputStream is = null;
		HttpURLConnection conn = null;
	
		URL url = new URL(this.getPath(parentPath, prefix, resource));
		conn = (HttpURLConnection) url.openConnection();
		conn.setRequestMethod("GET");
		conn.setDoInput(true);
		conn.connect();
		if( conn.getResponseCode() == HttpURLConnection.HTTP_OK ) {
			is = conn.getInputStream();
		}
		return is;
	}

	@Override
	public boolean write(String parentPath, String prefix, String resource, byte[] data) throws Exception {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public int listResource(String parentPath, String prefix, String resource, String flag, List<String> resources,
			List<String> names, List<Boolean> flags) throws Exception {
		InputStream is = null;
		HttpURLConnection conn = null;
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		try {
			URL url = new URL(this.getPath(parentPath, prefix, resource));
			conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("GET");
			conn.setDoInput(true);
			conn.connect();
			if( conn.getResponseCode() == HttpURLConnection.HTTP_OK ) {
				is = conn.getInputStream();
				byte[] buffer = new byte[256];
				int len = 0;
				while( (len = is.read(buffer)) > 0 ) {
					baos.write(buffer,0,len);
				}
				String s = new String(baos.toByteArray(), StandardCharsets.UTF_8);
				JSONArray arr = new JSONArray(s);
				for( int i = 0;i < arr.length();i++ ) {
					JSONObject o = arr.optJSONObject(i);
					String name = o.optString("name");
					resources.add(name);
					names.add(name);
					flags.add(o.optBoolean("isDirectory"));
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if( is != null ) {
				is.close();
			}
			if( baos != null ) {
				baos.close();
			}
		}
		return resources.size();
	}

	@Override
	public String getPath(String parentPath, String prefix, String resource){
		String fileName = null;
		if( prefix != null && !prefix.isEmpty() ) {
			fileName = prefix + "/" + resource;
		} else {
			fileName = resource;
		}	
		try {
			return parentPath + "?fileName=" + URLEncoder.encode(fileName,"UTF-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return parentPath + "?fileName=" + fileName;
		}
	}

}
