package com.bokesoft.yigo.meta.factory;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.app.MetaAppDefiniton;
import com.bokesoft.yigo.meta.app.MetaClientAppDef;
import com.bokesoft.yigo.meta.archive.MetaArchive;
import com.bokesoft.yigo.meta.archive.MetaArchiveSetting;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.extend.MetaExConfiguration;
import com.bokesoft.yigo.meta.bpm.process.monitor.MetaBPMMonitorSetting;
import com.bokesoft.yigo.meta.bpm.process.perm.extend.MetaPermConfiguration;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.charging.MetaChargingObject;
import com.bokesoft.yigo.meta.charging.MetaChargingObjectList;
import com.bokesoft.yigo.meta.charging.MetaChargingRuleGroup;
import com.bokesoft.yigo.meta.charging.MetaChargingRuleGroupList;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontSourceCollection;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSourceCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.datamap.MetaDataMapList;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.entry.MetaEntryItem;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.flatcanvas.MetaFlatCanvasList;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCPaper;
import com.bokesoft.yigo.meta.form.MetaExtFormList;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeTable;
import com.bokesoft.yigo.meta.iosetting.MetaIOSetting;
import com.bokesoft.yigo.meta.mapping.MetaMapping;
import com.bokesoft.yigo.meta.midsetting.MetaMidSetting;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.offlinedef.MetaOfflineDef;
import com.bokesoft.yigo.meta.parameter.MetaParameter;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;
import com.bokesoft.yigo.meta.path.MetaRelationList;
import com.bokesoft.yigo.meta.path.MetaRelationPath;
import com.bokesoft.yigo.meta.path.MetaSecurityFilter;
import com.bokesoft.yigo.meta.path.check.MetaRelationCheck;
import com.bokesoft.yigo.meta.permission.custom.MetaCustomPermission;
import com.bokesoft.yigo.meta.permission.filter.MetaPermissionFilter;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportList;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.meta.rights.MetaRightsDefinition;
import com.bokesoft.yigo.meta.search.MetaElasticSearch;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.meta.task.MetaTaskProcess;
import com.bokesoft.yigo.meta.taskflow.MetaTaskFlow;

/**
 * IMetaFactory定义应用程序取得配置需要实现的方法，允许第三方开发者替换配置对象的获得方式，主要包括初始化、取得应用对象及工程中各对象
 * 
 * @author 王元和
 *
 */
public interface IMetaFactory {
	/**
	 * 元数据工厂环境的初始化，实现根据自身的需要实现相应的初始化
	 * 
	 * @throws Throwable 实现相关的异常
	 */
	public void init() throws Throwable;

	/**
	 * 获取应用元数据
	 * 
	 * @return 如果工厂提供了应用元数据，则返回，否则返回null
	 * @throws Throwable 实现相关的异常
	 * @see com.bokesoft.yigo.meta.solution.MetaSolution
	 */
	public MetaSolution getSolution() throws Throwable;

	/**
	 * 获取应用路径
	 * @return 应用路径
	 */
	public String getSolutionPath();

	/**
	 * 根据标识取得工程元数据
	 * 
	 * @param key 工程标识
	 * @return 如果存在相应工程定义，载入并返回工程元数据，否则返回null
	 * @throws Throwable 如果指定的工程标识不存在，返回工程未定义异常；其它实现相关异常
	 * @see com.bokesoft.yigo.meta.solution.MetaProject
	 */
	public MetaProject getMetaProject(String key) throws Throwable;

	/**
	 * 检查是否存在指定标识的表单配置
	 * @param key 表单标识
	 * @return 如果key指定的表单存在则返回true，否则返回false
	 * @throws Throwable 可能的异常
	 */
	public boolean hasMetaForm(String key) throws Throwable;
	
	/**
	 * 根据表单标识取得表单元数据
	 * 
	 * @param key 表单标识
	 * @return 如果存在相应的表单定义，载入并返回表单元数据，否则返回null
	 * @throws Throwable 如果指定的表单不存在，返回表单未定义异常；其它实现相关异常
	 * @see com.bokesoft.yigo.meta.form.MetaForm
	 */
	public MetaForm getMetaForm(String key) throws Throwable;
	
	/**
	 * 根据表单标识和模板标识取得表单元数据,用于反向模板
	 * @param key  表单标识
	 * @param templateKey 反向模板标识
	 * @return 如果存在相应的表单定义，载入并返回表单元数据，否则返回null
	 * @throws Throwable 读取配置中可能的异常
	 * 
	 * @see com.bokesoft.yigo.meta.form.MetaForm
	 */
	public MetaForm getMetaForm(String key, String templateKey) throws Throwable;
	
	/**
	 * 获取关系列表对象
	 * @return 关系列表对象
	 */
	public MetaRelationList getRelationList();
	
	/**
	 * 根据关系通路标识加载
	 * @param key 标识
	 * @return	关系通路
	 * @throws Throwable 读取配置相关的异常
	 */
	public MetaRelationPath getMetaRelationPath(String key) throws Throwable;
	
	/**
	 * 重载表单配置
	 * @param key 表单标识
	 * @throws Throwable 可能的错误
	 */
	public void reloadMetaForm(String key) throws Throwable;
	
	/**
	 * 替换表单配置
	 * @param key 表单标识
	 * @param metaForm 表单配置
	 * @throws Throwable 可能的错误
	 */
	public void replaceMetaForm(String key, MetaForm metaForm) throws Throwable;
	
	/**
	 * 替换MergeToSource马甲metaForm至源单
	 * @param key 表单标识
	 * @param metaForm 表单配置
	 * @throws Throwable 可能的错误
	 */
	public void replaceMetaForm4VestDiff(String key, MetaForm metaForm) throws Throwable;
	
	/**
	 * 替换自定义配置
	 * @param <T>
	 * @param key 表单标识
	 * @param clzz 表单配置
	 * @param object 表单配置
	 * @throws Throwable 可能的错误
	 */
	public <T> void replaceMetaCustomObject(String key,Class<T> clzz, KeyPairMetaObject object) throws Throwable;

	/**
	 * 获取表单对象的列表
	 * 
	 * @return 表单对象的列表
	 * @throws Throwable 实现相关的异常
	 */
	public MetaFormList getMetaFormList() throws Throwable;
	
	/**
	 * 获取所有CustomObject
	 * @return
	 */
	public List<KeyPairMetaObject> getCustomList();
	
	/**
	 * 获取solution下的commondef
	 * @return
	 */
	public MetaCommonDef getSolutionCommonDef();
	
	/**
	 * 设置solution下的commondef
	 * @param commondef
	 */
	public void setSolutionCommonDef(MetaCommonDef commondef);
	
	/**
	 * 取得数据对象列表
	 * 
	 * @return 数据对象列表
	 * @throws Throwable 实现相关的异常
	 */
	public MetaDataObjectList getDataObjectList() throws Throwable;

	/**
	 * 根据数据对象标识取得数据对象元数据
	 * 
	 * @param key 数据对象标识
	 * @return 如果存在相应的数据对象定义，返回相应的元数据，否则返回null
	 * @throws Throwable 实现相关的异常
	 */
	public MetaDataObject getDataObject(String key) throws Throwable;
	
	/**
	 * 重载数据对象配置
	 * @param key 数据对象标识
	 * @throws Throwable 可能的错误
	 */
	public void reloadDataObject(String key) throws Throwable;

	/**
	 * 取得迁移元数据列表
	 * 
	 * @return 迁移元数据列表
	 * @throws Throwable 实现相关的异常
	 */
	public MetaDataMigrationList getDataMigrationList() throws Throwable;

	/**
	 * 取得数据迁移定义
	 * 
	 * @param key 数据迁移标识
	 * @return 如果key指定的数据迁移存在，返回相应的元数据，否则返回null
	 * @throws Throwable 实现相关的异常
	 */
	public MetaDataMigration getDataMigration(String key) throws Throwable;

	/**
	 * 取得工程下安全过滤定义
	 * @param project 工程标识
	 * @return 安全过滤定义
	 * @throws Throwable 实现相关的异常
	 */
	public MetaSecurityFilter getSecurityFilter(String project) throws Throwable;
	/**
	 * 取得工程下的公共定义
	 * 
	 * @param project 工程标识，如果该值为空，返回应用下的公共定义
	 * @return 工程下定义的公共定义，如果没有，返回null
	 * @throws Throwable 实现相关的异常
	 */
	public MetaCommonDef getCommonDef(String project) throws Throwable;
	
	/***
	 * 获取工程下的移动端定义
	 * @param project 工程标识，如果该值为空，则返回应用下的移动端定义
	 * @return 工程下定义的公共定义，如果没有，返回null 
	 * @throws Throwable 实现相关的异常
	 */
	public MetaMobileDef getMobileDef(String project) throws Throwable;
	
	/**
	 * 取得工程下的功能扩展
	 * 
	 * @param project 工程标识，如果该值为空，返回应用下的功能扩展
	 * @return 工程下定义的功能扩展定义，如果没有，返回null
	 * @throws Throwable 实现相关的异常
	 */
	public MetaEnhance getEnhance(String project) throws Throwable;
	
	/**
	 * 获取不同的应用所引用的工程定义
	 * @return 定义文件
	 */
	public MetaAppDefiniton getAppDefinition();
	/**
	 * 根据工程标识取得工程下面的入口对象
	 * 
	 * @param key 工程标识
	 * @return 工程下面的入口对象元数据
	 * @throws Throwable 载入入口中可能的错误
	 */
	public MetaEntry getMetaEntry(String key) throws Throwable;

	/**
	 * 
	 * @param entryPath 入口路径
	 * @return 入口项定义
	 * @throws Throwable 读取配置相关的异常
	 */
	public MetaEntryItem getMetaEntryItem(String entryPath) throws Throwable;
	
	/**
	 * 根据资源路径加载资源
	 * 
	 * @param resource  资源路径
	 * @return 资源文件的输入流
	 * @throws Throwable 实现相关的异常
	 */
	public InputStream loadResource(String resource) throws Throwable;
	/**
	 * 根据资源路径加载资源（用于多solution）
	 * 
	 * @param resource  资源路径
	 * @projectKey 工程标识
	 * @return 资源文件的输入流
	 * @throws Throwable 实现相关的异常
	 */
	public InputStream loadResource(String resource, String projectKey) throws Throwable;
	
	/**
	 * 根据资源路径和解决方案标识加载资源
	 * 
	 * @param resource 资源路径
	 * @solutionKey 解决方案的标识
	 * @return 资源文件的输入流     获取solution标识对应解决方案的资源，如果没有找到，则到主Solution下面获取
	 * @throws Throwable 实现相关的异常
	 */
    public InputStream loadResourceBySolutionKey(String resource, String solutionKey) throws Throwable;

    /**
     * 根据资源路径读取配置文件
     * 
     * @param resource 文件资源路径
     * @return JSONObject 配置文件以JSONObject格式返回
     * @throws Throwable
     */
	public JSONObject readProfile(String resource) throws Throwable;

	/**
	 * 取得资源的URI路径
	 *
	 * @param resource 资源名称
	 * @return URI对象
	 * @throws Throwable 读取异常
	 */
	public URI getResourceURI(String resource) throws Throwable;

	/**
	 * 从工程目录下取得资源
	 *
	 * @param project
	 *            工程标识
	 * @param resource
	 *            资源路径
	 * @return 资源文件的输入流
	 * @throws Throwable 实现相关的异常
	 */
	public InputStream loadInputStream(String project, String resource) throws Throwable;

	/**
	 * 取得扩展的元数据工厂
	 * 
	 * @param tag
	 *            扩展标记
	 * @return 扩展元数据工厂
	 * @throws Throwable 实现相关的异常
	 */
	public IExtendMetaFactory getExtendMetaFactory(String tag) throws Throwable;

	/**
	 * 设置扩展的元数据工厂
	 * 
	 * @param tag
	 *            扩展标记
	 * @param factory
	 *            扩展的元数据工厂
	 * @throws Throwable 实现相关的异常
	 */
	public void putExtendMetaFactory(String tag, IExtendMetaFactory factory) throws Throwable;

	/**
	 * 取得数据映射元数据列表
	 *
	 * @return 数据映射元数据列表
	 * @throws Throwable 实现相关的异常
	 */
	public MetaDataMapList getDataMapList() throws Throwable;

	/**
	 * 取得数据映射定义
	 *
	 * @param key
	 *            数据映射标识
	 * @return 如果key指定的数据映射存在，返回相应的元数据，否则返回null
	 * @throws Throwable 实现相关的异常
	 */
	public MetaMap getDataMap(String key) throws Throwable;

	/**
	 * 取得业务流程元数据
	 *
	 * @return 业务流程元数据
	 * @throws Throwable 实现相关的异常
	 */
	public MetaBPM getMetaBPM() throws Throwable;

	/**
	 * 获取表单流程
	 * @param formKey 表单标识
	 * @return
	 * @throws Throwable
	 */
	public MetaProcess getBPMProcess(String formKey) throws Throwable;

	/**
	 * 重置业务流程元数据
	 *
	 * @return 业务流程元数据
	 * @throws Throwable 实现相关的异常
	 */
	public void reloadMetaBPM() throws Throwable;

	/**
	 * 根据流程的KEY获取已部署的流程定义（若相同KEY的流程均未部署，返回null）。
	 *
	 * @param processKey 过程标识
	 * @return 如果存在processKey定义的过程的布署版本则返回其定义，否则返回null
	 * @throws Throwable 实现相关的异常
	 */
	public MetaProcess getProcessDefinationByDeployKey(String processKey) throws Throwable;

	/**
	 * 根据流程的KEY和版本号获取指定流程定义
	 *
	 * @param processKey 过程标识
	 * @param verID      版本号
	 * @return 如果存在processKey指定过程的指定彼本则返回其定义，否则返回null
	 * @throws Throwable 实现相关的异常
	 */
	public MetaProcess getProcessDefinationBy(String processKey, int verID) throws Throwable;
	/**
	 * 根据标识获取指定的任务流程
	 * @param key 标识
	 * @return 任务流程
	 * @throws Throwable 异常
	 */
	public MetaTaskProcess getTaskProcessDefinitionByDeployKey(String key)throws Throwable;
	/**
	 * 根据标识和版本获取任务流程
	 * @param key 标识
	 * @param verID 版本
	 * @return 任务流程
	 * @throws Throwable 异常
	 */
	public MetaTaskProcess getTaskProcessDefinitionBy(String key, int verID)throws Throwable;
	/**
	 * 根据流程的KEY和版本号更新指定流程定义
	 * 
	 * @param processKey 过程标识
	 * @param verID 流程版本
	 * @throws Throwable 实现相关的异常
	 */
	public void updateProcessDefination(String processKey, int verID) throws Throwable;
	
	/**
	 * 根据流程的KEY更新已部署的流程定义（若相同KEY的流程均未部署，返回null）。
	 * 
	 * @param processKey 过程标识
	 * @throws Throwable 实现相关的异常
	 */
	public void updateProcessDefinationByDeployKey(String processKey) throws Throwable;
	/**
	 * 通过子列表标识取得报表的子列表
	 * 
	 * @param subKey 子列表标识
	 * @return 报表子列表
	 * @throws Throwable 实现相关的异常
	 */
	public MetaReportSubList getReportSubList(String subKey) throws Throwable;

	/**
	 * 通过报表分组标识，子列表标识和报表自身的标识取得报表的定义，在reportKey为空的情况下，取得默认报表定义
	 * 
	 * @param group 分组标识
	 * @param subKey 子列表标识
	 * @param reportKey 报表标识
	 * @return 报表定义
	 * @throws Throwable 实现相关的异常
	 */
	public MetaReport getReport(String group, String subKey, String reportKey) throws Throwable;

	/**
	 * 取得全局设置对象
	 * 
	 * @return 全局设置对象
	 */
	public MetaSetting getSetting();

	/**
	 * 设置全局设置对象
	 * @param setting 全局设置对象
	 */
	public void setSetting(MetaSetting setting);

	/**
	 * 根据FormKey获取Excel模板下拉项
	 *
	 * @param formKey
	 * @return
	 * @throws Throwable
	 */
	public String getExcelTemplateDropList(String formKey) throws Throwable;

	/**
	 * 获取Excel模板列表
	 *
	 *
	 * @return Excel模板列表
	 * @throws Throwable 实现相关的异常
	 */
	public MetaExcelTemplateList getMetaExcelTemplateList() throws Throwable;

	/**
	 * 获取Print模板列表
	 *
	 * @return Print模板列表
	 * @throws Throwable 实现相关的异常
	 */
	public MetaReportList getMetaReportList() throws Throwable;

	/**
	 * 获取Excel模板
	 *
	 * @param projectKey  项目key
	 * @param templateKey 模板key
	 * @return Excel模板
	 * @throws Throwable 实现相关的异常
	 */
	public MetaExcelWorkbook getExcelTemplate(String projectKey, String templateKey) throws Throwable;

	/**
	 * 取得ElasticSearch配置
	 *
	 * @return 搜索定义
	 */
	public MetaElasticSearch getElasticSearch();

	/**
	 * 取得客户端应用程序定义
	 *
	 * @return 客户端应用程序定义
	 */
	public MetaClientAppDef getClientAppDef();

	/**
	 * 获取权限定义
	 *
	 * @return 权限定义
	 */
	public MetaRightsDefinition getRightsDefinition();

	/**
	 * 设置权限定义
	 * 
	 * @param metaRightsDefinition
	 */
	public void setRightsDefinition(MetaRightsDefinition metaRightsDefinition);

	/**
	 * 是否有所给表单的所有权限
	 *
	 * @param formKey 表单标识
	 * @return 表单是否有所有权限
	 */
	public boolean hasAllFormRights(String formKey);

	/**
	 * 是否有所给字典的所有权限
	 *
	 * @param itemKey 字典标识
	 * @return 指定的字典是否有所有权限
	 */
	public boolean hasAllDictRights(String itemKey);

	/**
	 * 获取动态单元格定义列表
	 *
	 * @return 动态单元格定义列表
	 */
	public MetaCellTypeTable getCellTypeTable();

	/**
	 * 取得工程的资源处理器
	 *
	 * @param project 工程标识
	 * @return IMetaResolver对象
	 */
	public IMetaResolver getProjectResolver(String project);

	/**
	 * 获取拓展配置
	 *
	 * @return 拓展配置对象
	 */
	public MetaExConfiguration getExConfiguration();

	/**
	 * 获取外部权限配置
	 *
	 * @return 外部权限配置对象
	 */
	public MetaPermConfiguration getPermConfiguration();

	/**
	 * 获取归档配置
	 *
	 * @return 归档配置对象
	 */
	public MetaArchive getArchive();

	/**
	 * 获取归档设置
	 *
	 * @return 归档设置
	 */
	public MetaArchiveSetting getArchiveSetting();

	/**
	 * 取得IO设置
	 *
	 * @return IO设置对象
	 */
	public MetaIOSetting getIOSetting();

	/**
	 * 取得计费对象列表
	 *
	 * @return 计费对象列表
	 */
	public MetaChargingObjectList getChargingObjectList();

	/**
	 * 取得计费对象定义
	 *
	 * @param key 标识
	 * @return 如果key存在则返回计费对象定义，否则返回null
	 * @throws Throwable 读取错误
	 */
	public MetaChargingObject getChargingObject(String key) throws Throwable;

	/**
	 * 取得计费组列表
	 *
	 * @return 计费组列表
	 */
	public MetaChargingRuleGroupList getChargingRuleGroupList();

	/**
	 * 取得计费组定义
	 *
	 * @param key 标识
	 * @return 如果key存在则返回计费组定义，否则返回null
	 * @throws Throwable 读取错误
	 */
	public MetaChargingRuleGroup getChargingRuleGroup(String key) throws Throwable;

	/**
	 * 取得Solution下启用的project集合
	 *
	 * @return 所有工程标识的列表
	 */
	public List<String> getProjectKeys();

	/**
	 * 初始化CommondDef中的参数表
	 *
	 * @throws Throwable 初始化中可能的错误
	 */
	public void initParaTable() throws Throwable;

	/**
	 * 预加载实体表单
	 *
	 * @throws Throwable 加载中可能的错误
	 */
	public void preLoadEntity() throws Throwable;

	/**
	 * 加载多语言表单
	 *
	 * @throws Throwable 加载中可能的错误
	 */
	public void getAutoMetaForm(String key, MetaFormList AutoFormList) throws Throwable;

	/**
	 * 取得app关联的入口列表
	 *
	 * @param appKey 应用标识，可以为null或空或者为有效的应用标识
	 * @return 如果appKey不为null或空，则返回应用中包含的工程的入口列表，否则为全部入口
	 * @throws Throwable 实现相关的错误
	 */
	public MetaEntry getEntryList(String appKey) throws Throwable;

	/**
	 * 获取权限检查
	 *
	 * @return 关系检查定义
	 * @throws Throwable 实现相关的错误
	 */
	public MetaRelationCheck getRelationCheck() throws Throwable;


	/**
	 * 获取平面图列表
	 *
	 * @return 平面图列表
	 */
	public MetaFlatCanvasList getFlatCanvasList();

	/**
	 * 获取平面图配置对象
	 *
	 * @return 平面图配置对象
	 */
	public MetaFCPaper getMetaFCPaper(String key) throws Throwable;

	/**
	 * 获取用户自定义图形
	 *
	 * @param fileName 文件名称
	 * @return 文件
	 */
	public File getUserSVGFile(String fileName);

	/**
	 * 获取表单对应的多语言文件
	 *
	 * @param formKey 表单标识
	 * @param locale  本地化语种
	 * @return 字符串表
	 * @throws Throwable 实现可能的异常
	 */
	public MetaStringTable getMetaStringTable(String formKey, String locale) throws Throwable;

	/**
	 * 获取流程对应的多语言文件
	 *
	 * @param process 过程标识
	 * @return 字符串表
	 * @throws Throwable 实现可能的异常
	 */
	public MetaStringTable getProcessMetaStringTable(String process) throws Throwable;

	/**
	 * 获取数据对象对应的多语言文件
	 *
	 * @param dataObjKey 数据对象标识
	 * @return 字符串表
	 * @throws Throwable 实现可能的异常
	 */
	public MetaStringTable getDataObjMetaStringTable(String dataObjKey) throws Throwable;

	/**
	 * 获取表单对应的多语言文件
	 *
	 * @param formKey 表单标识
	 * @return 字符串表
	 * @throws Throwable 实现可能的异常
	 */
	public MetaStringTable getFormStrings(String formKey) throws Throwable;

	/**
	 * 获取工程多语言
	 *
	 * @param projectKey 工程标识
	 * @return 字符串表
	 * @throws Throwable 实现可能的异常
	 */
	public MetaStringTable getProjectStrings(String projectKey) throws Throwable;

	/**
	 * 获取流程对应的多语言文件
	 *
	 * @param processKey 过程标识
	 * @return 字符串表
	 * @throws Throwable 实现可能的异常
	 */
	public MetaStringTable getProcessStrings(String processKey) throws Throwable;

	/**
	 * 获取数据对象对应的多语言文件
	 *
	 * @param dataObjectKey 数据对象标识
	 * @return 字符串表
	 * @throws Throwable 实现可能的异常
	 */
	public MetaStringTable getDataObjectStrings(String dataObjectKey) throws Throwable;

	/**
	 * 取得中间层设置
	 *
	 * @return 中间层设置对象
	 */
	public MetaMidSetting getMidSetting();

	/**
	 * 获取指定标识的Mapping配置对象
	 *
	 * @param key 标识
	 * @return Mapping配置对象
	 */
	public MetaMapping getMapping(String key) throws Throwable;

	/**
	 * 获取自定义权限操作
	 *
	 * @return 自定义权限对象
	 */
	public MetaCustomPermission getCustomPermission();

	/**
	 * 获取服务权限过滤配置
	 *
	 * @return 服务权限过滤配置
	 */
	public MetaPermissionFilter getPermissionFilter();

	/**
	 * 获取流程监控配置
	 *
	 * @return 流程监控配置
	 */
	public MetaBPMMonitorSetting getBPMMonitorSetting();

	/**
	 * 获取自定义配置
	 *
	 * @param <S>  自定义参数模板参数
	 * @param clzz 配置对象类名
	 * @param key  配置对象的key
	 * @return 自定义配置
	 */
	public default <S> S getMetaCustomObject(Class<S> clzz, String key) {
		return null;
	}

	/**
	 * 获取自定义配置集合
	 *
	 * @param <S>  自定义参数模板参数
	 * @param clzz 配置对象类名
	 * @return 自定义配置集合
	 */
	public default <S> List<S> getMetaCustomObjects(Class<S> clzz) {
		return null;
	}

	/**
	 * 热部署一个流程
	 *
	 * @param projectKey 工程名
	 * @param resource   资源路径
	 * @throws Throwable 部署异常
	 */
	public void deployProcess(String projectKey, String resource) throws Throwable;

	/**
	 * 重新加载数据映射
	 *
	 * @param metaProject
	 * @param metaProjectProfile
	 * @throws Throwable
	 */
	public void reloadCustomList(MetaProject metaProject, MetaProjectProfile metaProjectProfile) throws Throwable;

	/**
	 * 获取以 Project 标识为 Key 的 {@link IMetaResolver} 对象. 注意: 该方法的返回结果是实际的内部存储对象, 可以直接进行增减操作
	 *
	 * @return
	 * @throws Throwable
	 */
	public Map<String, IMetaResolver> getProjectResolverMap() throws Throwable;

	/**
	 * 重新加载数据迁移
	 *
	 * @param key
	 * @throws Throwable
	 */
	public void reloadDataMigration(String key) throws Throwable;

	/**
	 * 获取任务流程
	 *
	 * @param key 标识
	 * @return 任务流程
	 * @throws Throwable 异常
	 */
	public MetaTaskFlow getTaskFlow(String key) throws Throwable;

	/**
	 * 获取配置目录国际化字符串
	 *
	 * @return MetaStringTable 配置目录国际化字符串
	 * @throws Throwable
	 */
	public MetaStringTable getStrings() throws Throwable;
	
	/**
	 * 根据语言类型获取配置目录国际化字符串
	 * 
	 * @param lang 语言类型
	 * @return MetaStringTable 相对语言的配置目录国际化字符串
	 * @throws Throwable
	 */
	public MetaStringTable getStrings(String lang) throws Throwable;

	/**
	 * 设置当前环境的多语言字符串
	 * 
	 * @param strings 用来存储语言字符串的对象
	 * @throws Throwable
	 */
	public void setStrings(MetaStringTable strings) throws Throwable;

	/**
	 * 获取配置目录国际化数据映射字符串
	 *
	 * @return MetaStringTable 配置目录国际化数据映射字符串
	 * @throws Throwable
	 */
	public MetaStringTable getDataMapStrings() throws Throwable;

	/**
	 * 获取配置目录国际化数据迁移字符串
	 *
	 * @return MetaStringTable 配置目录国际化数据迁移字符串
	 * @throws Throwable
	 */
	public MetaStringTable getDataMigrationStrings() throws Throwable;

	/**
	 * excel文件模板信息
	 *
	 * @param projectKey
	 * @param templateKey
	 * @return
	 * @throws Throwable
	 */
	public byte[] getExcelFileTemplate(String projectKey, String templateKey) throws Throwable;

	/**
	 * 获取参数表
	 * 
	 * @return  多solution的时候返回的是所有solution的ParaGroup集合
	 *
	 * @throws Throwable
	 */
	public MetaParaTable getParaTable() throws Throwable;/**
	 *
	 * 获取参数
	 *
	 * @return  多solution的时候返回的是所有solution的Parameter集合
	 *
	 * @throws Throwable
	 */
	public MetaParameter getParameter() throws Throwable;

	/**
	 * 获取状态集合
	 *
	 * @param formKey 表单标识
	 * @return
	 * @throws Throwable
	 */
	public MetaStatusCollection getStatusCollection(String formKey) throws Throwable;

	/**
	 * 动态更新单个配置文件
	 *
	 * @param projectKey  工程key
	 * @param objectKey   配置对象key
	 * @param parentFold  对应配置文件所在模块下的父目录
	 * @param sModuleType 模块标志
	 * @throws Throwable
	 */
	public void updateMetaFile(String projectKey, String objectKey, String parentFold, String sModuleType) throws Throwable;

	/**获取移动离线定义
	 * 
	 * @return MetaOfflineDef 离线配置信息
	 */
	public MetaOfflineDef getOfflineDef();

	/**
	 * 重新加载表单(针对设计模式), 针对设计模式时, 一些正常运行时的性能优化等处理步骤可以被延后或者忽略
	 * @param key
	 * @throws Throwable
	 */
	public void reloadDesignMetaForm(String key) throws Throwable;

	/**
	 * 获取表单(针对设计模式), 针对设计模式时, 一些正常运行时的性能优化等处理步骤可以被延后或者忽略
	 * @param key
	 * @return
	 * @throws Throwable
	 */
	public MetaForm getDesignMetaForm(String key) throws Throwable;

	/**
	 * 获取扩展表单对象
	 *
	 * @param sourceFormkey 源单标识
	 * @param extFormKey    扩展表单标识
	 * @return 如果存在相应的表单定义，载入并返回表单元数据，否则返回null
	 * @throws Throwable
	 * @see {@link MetaForm}
	 */
	public MetaForm getExtMetaForm(String sourceFormkey, String extFormKey) throws Throwable;

	/**
	 * 获取扩展表单列表
	 */
	public MetaExtFormList getExtFormList() throws Throwable;

	/**
	 * 获取工程对应Solution的SolutionCommonDef,当solution为""的时候，能拿到主Solution的SolutionCommonDef（用于多Solution的情况）
	 *
	 * @param project 工程标识
	 * @return 相对应solution的SolutionCommonDef
	 * @throws Throwable
	 */
	public MetaCommonDef getSolutionCommondDef(String project) throws Throwable;

	/**
	 * 获取主solution的资源隔离接口
	 * 
	 * @return IMetaResolverFactory 主solution的资源隔离接口
	 */
	public IMetaResolverFactory getMetaResolverFactory();

	/**
	 * 获取工程对应Solution的MetaResolverFactory（这里不包含主Solution）
	 *
	 * @param project 工程标识
	 * @return 相对应solution的MetaResolverFactory
	 * @throws Throwable
	 */
	public IMetaResolverFactory getMetaResolverFactory(String project) throws Throwable;

	/**
	 * 获取IconSource的集合对象
	 * @return MetaIconSourceCollection IconSource的集合对象
	 * @throws Throwable
	 */
	public MetaIconSourceCollection getIconSourceCollection() throws Throwable;
	
	/**
	 * 获取IconFontSource的集合对象
	 * @return MetaIconSourceCollection IconFontSource的集合对象
	 * @throws Throwable
	 */
	public MetaIconFontSourceCollection getIconFontSourceCollection() throws Throwable;
	
	/**
	 * 获取所有Solution的对象集合
	 * @return MetaSolution的集合
	 */
	public Collection<MetaSolution> getMetaSolutions();

	/**
	 * 根据solution的标识获取非主solution的IMetaResolverFactory（仅限于多solution的情况，）
	 * @param solutionKey solution的标识
	 * @return IMetaResolverFactory 用于隔离资源获取
	 */
	public IMetaResolverFactory getMetaResolverFactoryBySolution(String solutionKey);

	/**
	 * 根据solution的标识获取MetaCommonDef（用于多solution）
	 * @param solutionKey solution的标识
	 * @return MetaCommonDef 公共定义对象
	 */
	public MetaCommonDef getCommonDefBySolution(String solutionKey);

	 /**
     * 根据指定的配置解析工厂加载配置,已废弃，由{@link #loadSolution}替代
     * @param resolverFactory 配置解析工厂
     * @param isMultiple 是否是多配置模式
     * @param isPrimary 是否是主配置
     * @param again 是否再次加载
     * @return 解析后的配置工厂
     * @throws Throwable
     */
	@Deprecated
	public IMetaFactory load(IMetaResolverFactory resolverFactory,boolean isMultiple, boolean isPrimary, boolean again) throws Throwable;

	 /**
     * 根据指定的配置解析工厂加载配置
     * @param resolverFactory 配置解析工厂
     * @param isMultiple 是否是多配置模式
     * @param isPrimary 是否是主配置
     * @param again 是否再次加载
     * @return MetaSolution
     * @throws Throwable
     */
	public MetaSolution loadSolution(IMetaResolverFactory resolverFactory, boolean isMultiple,
			boolean isPrimary, boolean again) throws Throwable;
	
	/**
	 * 根据Solution 标识获取数据元素定义 
	 * 
	 * @param solutionKey Solution 标识
	 * @return MetaDataElementDef 当 Solution 标识为空，获取主 Solution 的数据元素定义，否则获取非主 Solution 的数据元素定义
	 */
	public MetaDataElementDef getDataElementDef(String solutionKey);
	
	/**
	 * 获取以 Solution 标识为 Map Key 的所有数据元素配置对象定义. 注意: 该方法的返回结果是实际的内部存储对象, 可以直接进行增减操作
	 * 
	 * @return
	 */
	public Map<String, MetaDataElementDef> getSolutionDataElementDefMap() ;
	
	/**
	 * 获取以 Solution Key 为 Key 的所有域配置对象定义. 注意: 该方法的返回结果是实际的内部存储对象, 可以直接进行增减操作
	 *  
	 * @return
	 */
	public Map<String, MetaDomainDef> getSolutionDomainDefMap();
	
	/**
	 * 获取全局数据元素配置对象定义
	 * 
	 * @return
	 */
	public MetaDataElementDef getDataElementDef();
	
	/**
	 * 重新加载全局数据元素配置对象定义.
	 * FIXME 此次方法命名不准确, 实际仅仅是 reset 了全局数据元素配置定义, 并未进行加载
	 */
	public void reloadDataElementDef();

	/**
	 * 根据 Solution 标识获取域配置对象定义定义
	 * 
	 * @param solutionKey Solution 标识 
	 * @return MetaDomainDef 当 Solution solution标识为空，获取主 Solution 的域定义，否则获取非主 Solution 的域定义
	 */
	public MetaDomainDef getDomainDef(String solutionKey);
	
	/**
	 * 获取全局数据元素配置对象定义
	 * 
	 * @return
	 */
	public MetaDomainDef getDomainDef();
	
	/**
	 * 重新加载全局域配置对象定义.
	 * FIXME 此次方法命名不准确, 实际仅仅是 reset 了全局域配置对象定义, 并未进行加载
	 */
	public void reloadDomainDef();

	/**
	 * 通过工程标识，获取状态集合
	 * @param projectKey 工程标识
	 * @return 状态集合
	 * @throws Throwable
	 */
	public MetaStatusCollection getStatusCollectionByProjectKey(String projectKey) throws Throwable;

	/**
	 * 通过工程标识，获取状态集合
	 * @param projectKey 工程标识
	 * @param mergeOtherSolution 如果工程在如果是非主Solution中，获取的状态集合是否需要合并主Solution和其它Solution的状态集合
	 * @return 状态集合
	 * @throws Throwable
	 */
	public MetaStatusCollection getStatusCollectionByProjectKey(String projectKey, boolean mergeOtherSolution) throws Throwable;
	
	/**
	 * 通过工程标识，获取GlobalI18N
	 * @param projectKey 工程标识
	 * @return GlobalI18N
	 * @throws Throwable
	 */
	public GlobalI18N getI18N(String projectKey) throws Throwable;
}
