package com.bokesoft.yigo.meta.factory;

import java.io.File;
import java.io.IOException;
import java.util.Map;

import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.IConfigResolver;
import com.bokesoft.yigo.meta.base.IMetaResolver;

public class DefaultMetaResolverFactory implements IMetaResolverFactory {
	private IConfigResolver configResolver;
	private String solutionPath = "";
	
	public DefaultMetaResolverFactory(IConfigResolver configResolver, String solutionPath) {
		this.configResolver = configResolver;
		this.solutionPath = solutionPath;
	}
	
	public DefaultMetaResolverFactory(String solutionPath) {
		this.configResolver = new DefaultConfigResolver();
		this.solutionPath = solutionPath;
	}
	@Override
	public String getSolutionPath() {
		return this.solutionPath;
	}
	
	@Override
	public IMetaResolver newMetaResolver(String prefix) {
		return new DefaultResourceResolver(configResolver,solutionPath,prefix);
	}

	@Override
	public IMetaResolver newFileMetaResolver(String prefix) {
		String path = "";
		if (prefix.startsWith("/") || prefix.indexOf(":") > 0) {
			path = prefix;
		} else {
			File file = new File(solutionPath, prefix);
			try {
				path = file.getCanonicalPath();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return new DefaultResourceResolver(configResolver,path,"");
	}

	@Override
	public char getSeparator() {
		return File.separatorChar;
	}

	@Override
	public void initParas(Map<String, Object> paras) {
		if (paras != null && paras.containsKey("SOLUTIONPATH")) {
			solutionPath = TypeConvertor.toString(paras.get("SOLUTIONPATH"));
		}
	}

}
