package com.bokesoft.yigo.meta.enhance;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaPara;

/**
 * MetaFunction定义二次开发函数扩展的描述
 * @author wangyh
 *
 */
public class MetaFunction extends GenericKeyCollectionWithKey<MetaPara> {
	public static final String TAG_NAME = "Function";
	
	/** 描述 */
	private String description = "";
	/** 实现类 */
	private String provider = "";
	
	@Override
	public String getKey() {
		return provider;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaPara.TAG_NAME.equals(tagName)) {
			MetaPara metaPara = new MetaPara();
			metaPara.preProcessMetaObject(env, doc, node, flag, runType);
			add(metaPara);
			child = metaPara;
		}
		return child;
	}


	/**
	 * 设置实现类全路径名
	 * @param provider 实现类全路径名
	 */
	public void setProvider(String provider) {
		this.provider = provider;
	}
	
	/**
	 * 取得实现类全路径名
	 * @return 实现类全路径名
	 */
	public String getProvider() {
		return provider;
	}

	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return description;
	}

	

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFunction();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaFunction meta = (MetaFunction) super.clone();
		meta.setDescription(description);
		meta.setProvider(provider);
		return meta;
	}
}
