package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtAttachmentProcess extends GenericKeyCollection<MetaAttachmentProcess> implements IElementMerge<MetaExtAttachmentProcess>{

	public static final String TAG_NAME = "ExtAttachmentProcess";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if(MetaAttachmentProcess.TAG_NAME.equals(tagName)){
			MetaAttachmentProcess attachmentProcess = new MetaAttachmentProcess();
			attachmentProcess.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(attachmentProcess);
			resultMetaObject = attachmentProcess;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No MetaObject defined for " + tagName);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtAttachmentProcess();
	}

	@Override
	public MetaExtAttachmentProcess toMerge(MetaExtAttachmentProcess obj) {
		if (obj != null) {
			Iterator<MetaAttachmentProcess> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaAttachmentProcess metaAttachementProcess = (MetaAttachmentProcess) iterator.next();
				if (containsKey(metaAttachementProcess.getKey())) {
					throw new MetaException(MetaException.REPEAT_EXT_SERVICE_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatExtServiceDefined),
									metaAttachementProcess.getKey()));
				}
				add(metaAttachementProcess);
			}
		}
		return this;
	}

}
