package com.bokesoft.yigo.meta.domain;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 
 * 域配置对象，可定义在solution与project目录
 * Domain标识全局唯一
 *
 */
public class MetaDomainDef extends AbstractMetaObject implements IElementMerge<MetaDomainDef> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** 域定义集合 */
	private MetaDomainCollection domainCollection = null;

	/** solutionKey*/
    private String solutionKey;
    
	public MetaDomainDef() {
		super();
	}
	
	/**
	 * 获取域集合
	 * @return 域集合
	 */
    public MetaDomainCollection getDomainCollection() {
    	return this.domainCollection;
    }
    
    /**
     * 设置域集合
     * @param collection 域集合
     */
    public void setDomainCollection(MetaDomainCollection collection) {
    	this.domainCollection = collection;
    }
    
    /**
     * 获取solution标识
     * @return solution标识
     */
	public String getSolutionKey() {
		return solutionKey;
	}

	/**
	 * 设置solution标识
	 * @param solutionKey solution标识
	 */
	public void setSolutionKey(String solutionKey) {
		this.solutionKey = solutionKey;
	}
	
	/**
	 * 获取域
	 * @param key 标识
	 * @return 域
	 */
	public MetaDomain getDomain(String key) {
		MetaDomain meta = null;
		if(this.domainCollection != null) {
			meta = domainCollection.get(key);
		}
		return meta;
	} 
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(domainCollection);
	}
	
	public static final String TAG_NAME = "DomainDef";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaDomainCollection.TAG_NAME.equals(tagName) ) {
			this.domainCollection = new MetaDomainCollection();
			resultMetaObject = domainCollection;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDomainDef newObject = new MetaDomainDef();
		newObject.setDomainCollection(domainCollection == null ? null : (MetaDomainCollection)domainCollection.clone());
		newObject.setSolutionKey(solutionKey);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDomainDef();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {

	}

	@Override
	public MetaDomainDef toMerge(MetaDomainDef meta) {
		if(meta == null) {
			return this;
		}
		
		MetaDomainCollection collection = meta.getDomainCollection();
		if(collection == null) {
			return this;
		}
		
		if(domainCollection == null) {
			domainCollection = new MetaDomainCollection();
		}
		
		Iterator<MetaDomain> it = collection.iterator();
		MetaDomain item = null;
		while(it.hasNext()) {
			item = it.next();
			if(!domainCollection.containsKey(item.getKey())) {
				domainCollection.add(item);
			}else {
				throw new MetaException(MetaException.REPEAT_KEY_DEFINED,  SimpleStringFormat
						.format(StringTable.getString(null, "", StringTable.RepeatKeyDefined), item.getKey()));
			}
		}
		
		return this;
	}
}

