package com.bokesoft.yigo.meta.diff.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;

public class MetaDiffNodeAction extends BaseDomAction<MetaDiffNode> {

	@Override
	public void load(Document document, Element element, MetaDiffNode meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setDeleteAttrs(DomHelper.readAttr(element, MetaConstants.DIFF_DELETE_ATTRS, ""));
	}

	@Override
	public void save(Document document, Element element, MetaDiffNode meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DIFF_DELETE_ATTRS, meta.getDeleteAttrs(), "");
	}


}
