package com.bokesoft.yigo.meta.dataobject;

import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;

/**
 * 系统表结构
 * 
 * @author liux
 *
 */
public class SystemTableDataObjectCreater {

	public static final MetaDataObject getSystemTableDataObject() throws MetaException {
		MetaDataObject systemTableDao = new MetaDataObject();
		systemTableDao.setAutoGen(true);
		systemTableDao.setKey("SystemTable");
		systemTableDao.setPrimaryType(DataObjectPrimaryType.ENTITY);
		MetaTableCollection tableCollection = new MetaTableCollection();
		systemTableDao.setCaption("");
		systemTableDao.setTableCollection(tableCollection);

		MetaTable Sys_IDSeed = createTable(systemTableDao, "SYS_IDSeed");
		addColumn(Sys_IDSeed, "SeedID", DataType.INT, 0).setPrimaryKey(true);
		addColumn(Sys_IDSeed, "SeedMark", DataType.LONG, 0);
		addColumn(Sys_IDSeed, "Description", DataType.STRING, 255);
		addColumn(Sys_IDSeed, "CreateTime", DataType.DATE, 0);

		MetaTable Sys_Sequence = createTable(systemTableDao, "SYS_Sequence");
		addColumn(Sys_Sequence, "SequenceID", DataType.INT, 0);
		addColumn(Sys_Sequence, "NoPrefix", DataType.STRING, 100).setPrimaryKey(true);
		addColumn(Sys_Sequence, "Tag", DataType.STRING, 255);
		
		MetaTable USER_Attachment = createTable(systemTableDao, "USER_Attachment");
		addColumn(USER_Attachment, "OID", DataType.LONG, 0);
		addColumn(USER_Attachment, "SOID", DataType.LONG, 0);
		addColumn(USER_Attachment, "UploadTime", DataType.DATETIME, 0);
		addColumn(USER_Attachment, "UploadOperator", DataType.LONG, 0);
		addColumn(USER_Attachment, "Path", DataType.STRING, 150);
		addColumn(USER_Attachment, "Name", DataType.STRING, 150);
		addColumn(USER_Attachment, "UploadName", DataType.STRING, 150, false, true);// 不持久化,不查询
		addColumn(USER_Attachment, "FileSize", DataType.LONG, 0);
		addColumn(USER_Attachment, "UploadSize", DataType.LONG, 0);
		addColumn(USER_Attachment, "FileMD5", DataType.STRING, 150);
		addColumn(USER_Attachment, "Client", DataType.STRING, 150);
		addColumn(USER_Attachment, "Server", DataType.STRING, 150);
		MetaColumn metaColumn = addColumn(USER_Attachment, "Schedule", DataType.NUMERIC, 0);
		metaColumn.setPrecision(16);
		metaColumn.setScale(3);
		addColumn(USER_Attachment, "UploadStatus", DataType.STRING, 20);
		
		MetaTable SYS_RoleEntryRights = createTable(systemTableDao, "SYS_RoleEntryRights");
		addColumn(SYS_RoleEntryRights, "RoleID", DataType.LONG, 0);
		addColumn(SYS_RoleEntryRights, "EntryKey", DataType.STRING, 512);
		addColumn(SYS_RoleEntryRights, "HasRights", DataType.INT, 0);
		MetaIndex index = new MetaIndex();
		MetaIndexCollection indexCollection = new MetaIndexCollection();
		index.setColumns("RoleID");
		index.setKey(SYS_RoleEntryRights.getIndexPrefix4Create() + "RoleID");
		indexCollection.add(index);
		SYS_RoleEntryRights.setIndexCollection(indexCollection);

		MetaTable SYS_WorkingCalendar = createTable(systemTableDao, "SYS_WorkingCalendar");
		addColumn(SYS_WorkingCalendar, "OID", DataType.LONG, 0).setPrimaryKey(true);
		addColumn(SYS_WorkingCalendar, "Date", DataType.STRING, 255);
		addColumn(SYS_WorkingCalendar, "ClusterID", DataType.LONG, 0);
		addColumn(SYS_WorkingCalendar, "isWorkDay", DataType.INT, 0);
		
		MetaTable SYS_WorkingTime = createTable(systemTableDao, "SYS_WorkingTime");
		addColumn(SYS_WorkingTime, "OID", DataType.LONG, 0).setPrimaryKey(true);
		addColumn(SYS_WorkingTime, "WorkingTime", DataType.STRING, 255);
		addColumn(SYS_WorkingTime, "ClusterID", DataType.LONG, 0);
		
		MetaTable SYS_OperatorEntryRights = createTable(systemTableDao, "SYS_OperatorEntryRights");
		addColumn(SYS_OperatorEntryRights, "OperatorID", DataType.LONG, 0);
		addColumn(SYS_OperatorEntryRights, "EntryKey", DataType.STRING, 512);
		addColumn(SYS_OperatorEntryRights, "HasRights", DataType.INT, 0);
		index = new MetaIndex();
		indexCollection = new MetaIndexCollection();
		index.setColumns("OperatorID");
		index.setKey(SYS_OperatorEntryRights.getIndexPrefix4Create() + "OperatorID");
		indexCollection.add(index);
		SYS_OperatorEntryRights.setIndexCollection(indexCollection);

		MetaTable SYS_RoleOptRights = createTable(systemTableDao, "SYS_RoleOptRights");
		addColumn(SYS_RoleOptRights, "RoleID", DataType.LONG, 0).setPrimaryKey(true);
		addColumn(SYS_RoleOptRights, "FormKey", DataType.STRING, 64).setPrimaryKey(true);
		addColumn(SYS_RoleOptRights, "OptKey", DataType.STRING, 64).setPrimaryKey(true);
		addColumn(SYS_RoleOptRights, "HasRights", DataType.INT, 0);

		MetaTable SYS_OperatorOptRights = createTable(systemTableDao, "SYS_OperatorOptRights");
		addColumn(SYS_OperatorOptRights, "OperatorID", DataType.LONG, 0).setPrimaryKey(true);
		addColumn(SYS_OperatorOptRights, "FormKey", DataType.STRING, 64).setPrimaryKey(true);
		addColumn(SYS_OperatorOptRights, "OptKey", DataType.STRING, 64).setPrimaryKey(true);
		addColumn(SYS_OperatorOptRights, "HasRights", DataType.INT, 0);

		MetaTable SYS_RoleFieldRights = createTable(systemTableDao, "SYS_RoleFieldRights");
		addColumn(SYS_RoleFieldRights, "RoleID", DataType.LONG, 0).setPrimaryKey(true);
		addColumn(SYS_RoleFieldRights, "FormKey", DataType.STRING, 64).setPrimaryKey(true);
		addColumn(SYS_RoleFieldRights, "FieldKey", DataType.STRING, 64).setPrimaryKey(true);
		addColumn(SYS_RoleFieldRights, "Visible", DataType.INT, 0);
		addColumn(SYS_RoleFieldRights, "Enable", DataType.INT, 0);
		addColumn(SYS_RoleFieldRights, "HasRights", DataType.INT, 0);

		MetaTable SYS_OperatorFieldRights = createTable(systemTableDao, "SYS_OperatorFieldRights");
		addColumn(SYS_OperatorFieldRights, "OperatorID", DataType.LONG, 0).setPrimaryKey(true);
		addColumn(SYS_OperatorFieldRights, "FormKey", DataType.STRING, 64).setPrimaryKey(true);
		addColumn(SYS_OperatorFieldRights, "FieldKey", DataType.STRING, 64).setPrimaryKey(true);
		addColumn(SYS_OperatorFieldRights, "Visible", DataType.INT, 0);
		addColumn(SYS_OperatorFieldRights, "Enable", DataType.INT, 0);
		addColumn(SYS_OperatorFieldRights, "HasRights", DataType.INT, 0);

		MetaTable SYS_RoleFormRights = createTable(systemTableDao, "SYS_RoleFormRights");
		addColumn(SYS_RoleFormRights, "RoleID", DataType.LONG, 0);
		addColumn(SYS_RoleFormRights, "FormKey", DataType.STRING, 64);
		addColumn(SYS_RoleFormRights, "HasRights", DataType.INT, 0);

		MetaTable SYS_OperatorFormRights = createTable(systemTableDao, "SYS_OperatorFormRights");
		addColumn(SYS_OperatorFormRights, "OperatorID", DataType.LONG, 0);
		addColumn(SYS_OperatorFormRights, "FormKey", DataType.STRING, 64);
		addColumn(SYS_OperatorFormRights, "HasRights", DataType.INT, 0);

		MetaTable SYS_Para = createTable(systemTableDao, "SYS_Para");
		addColumn(SYS_Para, "ParaKey", DataType.STRING, 50);
		addColumn(SYS_Para, "ParaValue", DataType.STRING, 1024);
		addColumn(SYS_Para, "ParaVer", DataType.INT, 0);

		MetaTable SYS_SessionLog = createTable(systemTableDao, "SYS_SessionLog");
		addColumn(SYS_SessionLog, SystemField.OID_SYS_KEY, DataType.LONG, 0);
		addColumn(SYS_SessionLog, "ClientID", DataType.STRING, 50);
		addColumn(SYS_SessionLog, "Operator", DataType.LONG, 0);
		addColumn(SYS_SessionLog, "Happentime", DataType.DATETIME, 0);
		addColumn(SYS_SessionLog, "Flag", DataType.INT, 0);
		addColumn(SYS_SessionLog, "IP", DataType.STRING, 50);
		addColumn(SYS_SessionLog, "Session_Mode", DataType.INT, 0);
		addColumn(SYS_SessionLog, "Host", DataType.STRING, 50);
		addColumn(SYS_SessionLog, "Port", DataType.STRING, 50);
		addColumn(SYS_SessionLog, "Notes", DataType.STRING, 100);

		MetaTable SYS_OperatorCertificate = createTable(systemTableDao, "SYS_OperatorCertificate");
		addColumn(SYS_OperatorCertificate, "OID", DataType.LONG, 0);
		addColumn(SYS_OperatorCertificate, "OperatorID", DataType.LONG, 0);
		addColumn(SYS_OperatorCertificate, "Fingerprint", DataType.STRING, 1024);
		addColumn(SYS_OperatorCertificate, "ClientName", DataType.STRING, 255);
		addColumn(SYS_OperatorCertificate, "Alias", DataType.STRING, 100);
		addColumn(SYS_OperatorCertificate, "PublicKey", DataType.STRING, 1024);
		addColumn(SYS_OperatorCertificate, "PrivateKey", DataType.STRING, 1024);
		addColumn(SYS_OperatorCertificate, "StartTime", DataType.DATETIME, 0);
		addColumn(SYS_OperatorCertificate, "EndTime", DataType.DATETIME, 0);
		addColumn(SYS_OperatorCertificate, "UpdateTime", DataType.DATETIME, 0);
		addColumn(SYS_OperatorCertificate, "Flag", DataType.INT, 0);

		MetaTable SYS_OperateFingerprintCheck = createTable(systemTableDao, "SYS_OperateFingerprintCheck");
		addColumn(SYS_OperateFingerprintCheck, "OID", DataType.LONG, 0);
		addColumn(SYS_OperateFingerprintCheck, "OperatorID", DataType.LONG, 0);
		addColumn(SYS_OperateFingerprintCheck, "MetaKey", DataType.STRING, 128);
		addColumn(SYS_OperateFingerprintCheck, "CmdKey", DataType.STRING, 100);

		MetaTable SYS_RelationDataObject = createTable(systemTableDao, "SYS_RelationDataObject");
		addColumn(SYS_RelationDataObject, "OperatorID", DataType.LONG, 0);
		addColumn(SYS_RelationDataObject, "OperationType", DataType.INT, 0);
		addColumn(SYS_RelationDataObject, "DataObjectKey", DataType.STRING, 255);

		MetaTable SYS_RelationScript = createTable(systemTableDao, "SYS_RelationScript");
		addColumn(SYS_RelationScript, "OperatorID", DataType.LONG, 0);
		addColumn(SYS_RelationScript, "FormKey", DataType.STRING, 255);
		addColumn(SYS_RelationScript, "ScriptName", DataType.STRING, 255);

		MetaTable SYS_RelationService = createTable(systemTableDao, "SYS_RelationService");
		addColumn(SYS_RelationService, "OperatorID", DataType.LONG, 0);
		addColumn(SYS_RelationService, "ServiceName", DataType.STRING, 255);
		
		MetaTable SYS_RoleCustomOptRights=createTable(systemTableDao, "SYS_RoleCustomOptRights");
		addColumn(SYS_RoleCustomOptRights, "RoleID", DataType.LONG, 0);
		addColumn(SYS_RoleCustomOptRights, "GroupKey", DataType.STRING, 255);
		addColumn(SYS_RoleCustomOptRights, "OptKey",  DataType.STRING, 255);
		addColumn(SYS_RoleCustomOptRights, "HasRights", DataType.INT, 0);
		
		MetaTable SYS_OperatorCustomOptRights=createTable(systemTableDao, "SYS_OperatorCustomOptRights");
		addColumn(SYS_OperatorCustomOptRights, "OperatorID", DataType.LONG, 0);
		addColumn(SYS_OperatorCustomOptRights, "GroupKey", DataType.STRING, 255);
		addColumn(SYS_OperatorCustomOptRights, "OptKey",  DataType.STRING, 255);
		addColumn(SYS_OperatorCustomOptRights, "HasRights", DataType.INT, 0);
		
//		MetaTable SYS_OperatorServiceRights = createTable(systemTableDao, "SYS_OperatorServiceRights");
//		addColumn(SYS_OperatorServiceRights, "OperatorID", DataType.LONG, 0);
//		addColumn(SYS_OperatorServiceRights, "ServiceID", DataType.STRING, 255);
//		addColumn(SYS_OperatorServiceRights, "FormKey", DataType.STRING, 255);
//		addColumn(SYS_OperatorServiceRights, "HasRights", DataType.INT, 0);
//		addIndex(SYS_OperatorServiceRights, "OperatorID", "OperatorID");
//			
//		MetaTable SYS_RoleServiceRights = createTable(systemTableDao, "SYS_RoleServiceRights");
//		addColumn(SYS_RoleServiceRights, "RoleID", DataType.LONG, 0);
//		addColumn(SYS_RoleServiceRights, "ServiceID", DataType.STRING, 255);
//		addColumn(SYS_RoleServiceRights, "FormKey", DataType.STRING, 255);
//		addColumn(SYS_RoleServiceRights, "HasRights", DataType.INT, 0);
//		addIndex(SYS_RoleServiceRights, "RoleID", "RoleID");
		
		//系统锁
		MetaTable SYS_Lock = createTable(systemTableDao, "SYS_Lock");
		addColumn(SYS_Lock, "UniqueKey", DataType.STRING, 255).setPrimaryKey(true);
		
		//系统临时表
		MetaTable SYS_DBTemp=createTable(systemTableDao, "sys_dbtemp");
		addColumn(SYS_DBTemp, "tempid", DataType.LONG, 0);
		addColumn(SYS_DBTemp, "vstr", DataType.STRING, 255);
		addColumn(SYS_DBTemp, "vnum",  DataType.LONG, 0);
		addColumn(SYS_DBTemp, "vtag", DataType.STRING, 255);
		addIndex(SYS_DBTemp, "tempid", "tempid");
		
		//应用服务编号生成池
		MetaTable SYS_ServerIDPool = createTable(systemTableDao, "Sys_ServerIDPool");
		addColumn(SYS_ServerIDPool, "ID", DataType.INT, 0);
		addColumn(SYS_ServerIDPool, "MacAddress", DataType.STRING, 20);
		addColumn(SYS_ServerIDPool, "ServerPort", DataType.INT, 0);
		MetaIndex SYS_ServerIDPoolIndex = new MetaIndex();
		indexCollection = new MetaIndexCollection();
		SYS_ServerIDPoolIndex.setKey("I_Sys_ServerIDPool");
		SYS_ServerIDPoolIndex.setColumns("ID");
		SYS_ServerIDPoolIndex.setUnique(true);
		indexCollection.add(SYS_ServerIDPoolIndex);
		SYS_ServerIDPool.setIndexCollection(indexCollection);
		
		return systemTableDao;
	}

	private static MetaTable createTable(MetaDataObject dataObject, String key) {
		MetaTable table = new MetaTable();
		table.setKey(key);
		table.setCaption("");
		table.setDBTableName("");
		table.setFilter(null);
		table.setSourceType(TableSourceType.DATAOBJECT);
		table.setTableMode(TableMode.DETAIL);
		return dataObject.getTableCollection().add(table);
	}
	
	private static MetaColumn addColumn(MetaTable table, String key, int dataType, int length,boolean persist,boolean ignoreQuery) {
		return _addColumn(table, key, dataType, length, persist, ignoreQuery);
	}
	
	private static MetaColumn addColumn(MetaTable table, String key, int dataType, int length) {
		return _addColumn(table, key, dataType, length, true, false);
	}
	
	private static MetaColumn _addColumn(MetaTable table, String key, int dataType, int length, boolean persist, boolean ignoreQuery) {
		MetaColumn column = new MetaColumn();
		column.setKey(key);
		column.setCaption("");
		column.setPersist(persist);
		column.setIgnoreQuery(ignoreQuery);
		column.setDefaultValue("");
		column.setDescription("");
		column.setDBColumnName("");
		column.setDataType(dataType);
		column.setLength(length);
		column.setAutoGen(true);
		table.add(column);
		return column;
	}
	
	private static MetaIndex addIndex(MetaTable table, String key, String columns) {
		MetaIndexCollection indexCollection = table.getIndexCollection();
		if (indexCollection == null) {
			indexCollection = new MetaIndexCollection();
			table.setIndexCollection(indexCollection);
		}

		MetaIndex index = new MetaIndex();
		indexCollection.add(index);
		index.setColumns(columns);
		index.setKey(table.getIndexPrefix4Create() + key);
		return index;
	}
}
