package com.bokesoft.yigo.meta.dataobject;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 数据表集合配置对象
 * 
 * @author lishu
 * @since YES1.0
 */
public class MetaTableCollection extends GenericKeyCollection<MetaTable> {

	/** 表集合的标签 */
	public static final String TAG_NAME = "TableCollection";

	/** 表格的逻辑顺序 **/
	private ArrayList<String> tableLogicList = new ArrayList<String>();

	public int indexOf(MetaTable table) {
		int index = -1;
		Iterator<MetaTable> it = this.iterator();
		while (it.hasNext()) {
			index++;
			MetaTable metaTable = it.next();
			if (table.getKey().equals(metaTable.getKey()))
				return index;
		}
		return -1;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaTable.TAG_NAME)) {
			resultMetaObject = new MetaTable();
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
			add((MetaTable) resultMetaObject);
		}

		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTableCollection();
	}

	public ArrayList<String> getTableLogicList() {
		return tableLogicList;
	}

	public void setTableLogicList(ArrayList<String> tableLogicList) {
		this.tableLogicList = tableLogicList;
	}

	public void doPostProcess(String mainTableKey) throws MetaException {
		// 处于第三层和以下的数据表
		tableLogicList = new ArrayList<String>();
		if (mainTableKey != null){
			tableLogicList.add(mainTableKey);
		} else {
			tableLogicList.add("");
		}
		ArrayList<MetaTable> checkList = new ArrayList<MetaTable>();

		for (MetaTable table : this) {
			if (table.getTableMode() == TableMode.HEAD) {
				table.setLevelID(1);
				if (!table.getKey().equalsIgnoreCase(mainTableKey))
					tableLogicList.add(1, table.getKey());
			} else {
				String pk = table.getParentKey();
				if (pk != null && pk.length() > 0)
					checkList.add(table);
				else {
					table.setLevelID(2);
					tableLogicList.add(table.getKey());
				}
			}
		}

		ArrayList<MetaTable> tempRemoveList = new ArrayList<MetaTable>();
		while (checkList.size() > 0) {
			for (MetaTable table : checkList) {
				String pk = table.getParentKey();
				MetaTable parentTable = get(pk);
				if (parentTable == null)
					throw new MetaException(MetaException.UNLOCATE_DATA_LEVEL, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.UnlocateDataLevel), table.getKey()));

				if (parentTable.getLevelID() > 0) {
					table.setLevelID(parentTable.getLevelID() + 1);
					tableLogicList.add(table.getKey());
					tempRemoveList.add(table);
				}
			}
			if (tempRemoveList.size() == 0) {
				String errStr = "";
				for (MetaTable t : checkList)
					errStr = errStr + "\"" + t.getKey() + "\"";
				throw new MetaException(MetaException.UNLOCATE_DATA_LEVEL, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.UnlocateDataLevel), errStr));
			}

			checkList.removeAll(tempRemoveList);
			tempRemoveList.clear();
		}

	}
}
