package com.bokesoft.yigo.meta.dataobject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * MetaProcess表示数据对象中的一个处理步骤，由处理内容和描述组成
 * @see com.bokesoft.yigo.meta.common.MetaBaseScript
 * @author 王元和
 *
 */
public class MetaProcess extends MetaBaseScript {

	public static final String TAG_NAME = "Process";
	
	/** 处理描述，仅对处理的内容作一个文本描述 */
	private String description = "";
	public MetaProcess() {
		super(TAG_NAME);
	}

	/** 
	 * 设置文本描述
	 * @param description 文本描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得文本描述
	 * @return 文本描述
	 */
	public String getDescription() {
		return this.description;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaProcess newProcess = (MetaProcess) super.clone();
		newProcess.setDescription(description);
		return newProcess;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaProcess();
	}
	
	@Override
	public boolean needPreLoad() {
		return true;
	}
}
