package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaMigrationValueCompare extends MetaMigrationCheckRule {

	public static final String TAG_NAME = "MigrationValueCompare";

	/** 检查规则涉及的表名 */
	private String tableKey = "";

	/** 检查规则涉及的列名 */
	private String columnKey = "";

	/** 检查规则的类型，暂无应用，现在只有比规定值大这一个规则 */
	private Integer type = -1;

	/** 检查规则涉及的比较值 */
	private String value = "";
	

	public String getTableKey() {
		return tableKey;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	public String getColumnKey() {
		return columnKey;
	}

	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMigrationValueCompare clone = new MetaMigrationValueCompare();
		clone.setColumnKey(columnKey);
		clone.setTableKey(tableKey);
		clone.setType(type);
		clone.setValue(value);
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMigrationValueCompare();
	}

}
