package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilter;

public class MetaLayer extends AbstractMetaObject {
	
	/**
	 * 跟上层的关系 NONE 未设置
	 */
	public static final int RELATION_NONE = 0;
	
	/**
	 * 跟上层的关系，取值为Contain(包含)
	 */
	public static final int RELATION_CONTAIN = 1;
	
	/**
	 * 跟上层的关系，取值为Belong(从属)
	 */
	public static final int RELATION_BELONG = 2;

	
	/** 配置文件中对应节点的标签名称 */
	public static final String TAG_NAME = "Layer";

	/**
	 * 字典的标识
	 */
	private String itemKey = "";

	/**
	 * 当前层次字典的过滤条件。
	 */
	private MetaFilter filter = null;
	
	/**
	 * 跟上层的关系，取值为Contain(包含)、Belong(从属)。
	 */
	private Integer relation = 0;

	/**
	 * 关系字段所在的数据表标识
	 */
	private String tableKey = "";
	
	/**
	 * 关系字段所在的数据列标识
	 */
	private String columnKey = "";
	
	
	/**
	 * 设置下拉列表项的标识
	 * 
	 * @param key
	 *            标识
	 */
	public void setItemKey(String key) {
		this.itemKey = key;
	}

	/**
	 * 获取下拉列表项的标识
	 * 
	 * @return 标识
	 */
	public String getItemKey() {
		return itemKey;
	}
	
	/**
	 * 设置上下层关系
	 * @param relation 上下层关系
	 */
	public void setRelation(Integer relation) {
		this.relation = relation;
	}
	
	/**
	 * 获取上下层关系
	 * @return 上下层关系
	 */
	public Integer getRelation() {
		return relation;
	}
	
	/**
	 * 通过转换类型字符串获取上下层关系
	 * 
	 * @param relation
	 *            字符串
	 * @return 如果relation在取值范围内返回相应的数字标志，否则返回RELATION_NONE
	 */
	public static int parseRelation(String relation) {
		if (relation.equalsIgnoreCase("Contain")) {
			return RELATION_CONTAIN;
		} else if (relation.equalsIgnoreCase("Belong")) {
			return RELATION_BELONG;
		}
		return RELATION_NONE;
	}

	/**
	 * 获取上下层关系转换类型字符串
	 * @param type 上下层关系类型
	 * @return 大小写转换类型字符串
	 */
	public static String getRelationStr(int type) {
		if (type == RELATION_CONTAIN) {
			return "Contain";
		} else if (type == RELATION_BELONG) {
			return "Belong";
		}
		return "";
	}

	
	/**
	 * 设置关系字段所在的数据表标识
	 * @param tableKey 表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 获取关系字段所在的数据表标识
	 * @return 表标识
	 */
	public String getTableKey(){
		return this.tableKey;
	}
	
	/**
	 * 设置 关系字段所在的数据列标识
	 * @param columnKey 列标识
	 */
	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}
	
	/**
	 * 获取 关系字段所在的数据列标识
	 * @return 列标识
	 */
	public String getColumnKey() {
		return columnKey;
	}
	
	
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( this.filter != null ) {
			list.add(filter);
		}
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaFilter.TAG_NAME.equals(tagName) ) {
			this.filter = new MetaFilter();
			resultMetaObject = filter;
		}
		return resultMetaObject;
	}

	@Override
	public boolean needPreLoad() {
		return true;
	}

	/**
	 * 设置过滤条件
	 * @param filter 过滤条件
	 */
	public void setFilter(MetaFilter filter) {
		this.filter = filter;
	}
	
	/**
	 * 取得过滤条件
	 * @return 过滤条件
	 */
	public MetaFilter getFilter() {
		return this.filter;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaLayer newObject = new MetaLayer();
		newObject.setItemKey(itemKey);
		newObject.setRelation(relation);
		newObject.setTableKey(tableKey);
		newObject.setColumnKey(columnKey);
		newObject.setFilter(filter == null ? null : (MetaFilter)filter.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLayer();
	}
}

