package com.bokesoft.yigo.meta.dataelement;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 数据元素配置对象，可定义在solution与project目录
 * DataElement标识全局唯一
 * DataElement处理需在Domain之后
 */
public class MetaDataElementDef extends AbstractMetaObject implements IElementMerge<MetaDataElementDef> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** 数据元素定义集合 */
	private MetaDataElementCollection dataElementCollection = null;
	
	/** solutionKey*/
    private String solutionKey;
	
	public MetaDataElementDef() {
		super();
	}
	
    public MetaDataElementCollection getDataElementCollection() {
    	return this.dataElementCollection;
    }
    
    public void setDataElementCollection(MetaDataElementCollection collection) {
    	this.dataElementCollection = collection;
    }
    
	public String getSolutionKey() {
		return solutionKey;
	}

	public void setSolutionKey(String solutionKey) {
		this.solutionKey = solutionKey;
	}
	
	public MetaDataElement getDataElement(String key) {
		MetaDataElement meta = null;
		if(this.dataElementCollection != null) {
			meta = dataElementCollection.get(key);
		}
		return meta;
	} 

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(dataElementCollection);
	}
	
	public static final String TAG_NAME = "DataElementDef";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaDataElementCollection.TAG_NAME.equals(tagName) ) {
			this.dataElementCollection = new MetaDataElementCollection();
			resultMetaObject = dataElementCollection;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDataElementDef newObject = new MetaDataElementDef();
		newObject.setDataElementCollection(dataElementCollection == null ? null : (MetaDataElementCollection)dataElementCollection.clone());
		newObject.setSolutionKey(solutionKey);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataElementDef();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		if(dataElementCollection == null) {
			return;
		}
		
		Iterator<MetaDataElement> it = dataElementCollection.iterator();
		MetaDataElement item = null;
		while(it.hasNext()) {
			item = it.next();
			item.doPostProcess(flag, callback);
		}
	}

	@Override
	public MetaDataElementDef toMerge(MetaDataElementDef meta) {
		if(meta == null) {
			return this;
		}
		
		MetaDataElementCollection collection = meta.getDataElementCollection();
		if(collection == null) {
			return this;
		}
		
		if(dataElementCollection == null) {
			dataElementCollection = collection;
		}else {
			Iterator<MetaDataElement> it = collection.iterator();
			MetaDataElement item = null;
			while(it.hasNext()) {
				item = it.next();
				if(!dataElementCollection.containsKey(item.getKey())) {
					dataElementCollection.add(item);
				}else {
					throw new MetaException(MetaException.REPEAT_KEY_DEFINED,  SimpleStringFormat
							.format(StringTable.getString(null, "", StringTable.RepeatKeyDefined), item.getKey()));
				}
			}
		}
		return this;
	}

}

