package com.bokesoft.yigo.meta.commondef;

import java.util.LinkedList;
import java.util.TreeMap;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.rights.MetaRightsDefinition;

public class MetaStatusCollection extends GenericKeyCollection<MetaStatus> implements IElementMerge<MetaStatusCollection> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "StatusCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaStatus.TAG_NAME.equalsIgnoreCase(tagName)) {
			MetaStatus metaStatus = new MetaStatus();
			metaStatus.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaStatus);
			resultMetaObject = metaStatus;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStatusCollection();
	}

	/** 状态集合 */
	private TreeMap<Integer, String> map = null;

	/**
	 * 通过状态字段的值查找对应的状态KEY
	 * 
	 * @param value 整型值
	 * @return 根据整型值取得状态的字符串表示
	 */
	public String getKeyByIntValue(int value) {
		if (map == null) {
			synchronized (elementMap) {
				if (map == null) {
					map=new TreeMap<Integer, String>();
					for (MetaStatus metaStatus : this)
						map.put(metaStatus.getValue(), metaStatus.getKey());
				}
			}
		}
		return map.get(value);
	}

	@Override
	public MetaStatusCollection toMerge(MetaStatusCollection obj) {
		if (obj == null) {
			return this;
		}
		for (MetaStatus status : obj) {
			if (containsKey(status.getKey())) {
				continue;
			}
			add(status);
		}
		return this;
	}
}
